/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer;

import de.javagl.jgltf.model.BufferViewModel;
import de.javagl.jgltf.model.ImageModel;
import de.javagl.jgltf.model.Optionals;
import de.javagl.jgltf.model.TextureModel;
import de.javagl.jgltf.model.gl.ProgramModel;
import de.javagl.jgltf.model.gl.ShaderModel;
import de.javagl.jgltf.model.image.PixelData;
import de.javagl.jgltf.model.image.PixelDatas;
import de.javagl.jgltf.viewer.GlContext;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

class GltfRenderData {
    private static final Logger logger = Logger.getLogger(GltfRenderData.class.getName());
    private final List<Integer> glVertexArrays;
    private final Map<ProgramModel, Integer> programModelToGlProgram;
    private final Map<TextureModel, Integer> textureModelToGlTexture;
    private final Map<BufferViewModel, Integer> bufferViewModelToGlBufferView;
    private final GlContext glContext;

    GltfRenderData(GlContext glContext) {
        this.glContext = Objects.requireNonNull(glContext, "The glContext may not be null");
        this.glVertexArrays = new ArrayList<Integer>();
        this.programModelToGlProgram = new LinkedHashMap<ProgramModel, Integer>();
        this.textureModelToGlTexture = new LinkedHashMap<TextureModel, Integer>();
        this.bufferViewModelToGlBufferView = new LinkedHashMap<BufferViewModel, Integer>();
    }

    void addGlVertexArray(int glVertexArray) {
        this.glVertexArrays.add(glVertexArray);
    }

    Integer obtainGlProgram(ProgramModel programModel) {
        Integer glProgram = this.programModelToGlProgram.get(programModel);
        if (glProgram == null && !this.programModelToGlProgram.containsKey(programModel)) {
            glProgram = this.createGlProgram(programModel);
            this.programModelToGlProgram.put(programModel, glProgram);
        }
        return glProgram;
    }

    private Integer createGlProgram(ProgramModel programModel) {
        logger.fine("Creating GL program for " + programModel);
        ShaderModel vertexShaderModel = programModel.getVertexShaderModel();
        ShaderModel fragmentShaderModel = programModel.getFragmentShaderModel();
        Integer glProgram = this.glContext.createGlProgram(vertexShaderModel.getShaderSource(), fragmentShaderModel.getShaderSource());
        if (glProgram != null) {
            logger.fine("Creating GL program for " + programModel + " DONE");
        } else {
            logger.warning("Creating GL program for " + programModel + " FAILED");
        }
        return glProgram;
    }

    Integer obtainGlTexture(TextureModel textureModel) {
        Integer glTexture = this.textureModelToGlTexture.get(textureModel);
        if (glTexture == null && !this.textureModelToGlTexture.containsKey(textureModel)) {
            glTexture = this.createGlTexture(textureModel);
            this.textureModelToGlTexture.put(textureModel, glTexture);
        }
        return glTexture;
    }

    private Integer createGlTexture(TextureModel textureModel) {
        logger.fine("Creating GL texture for texture " + textureModel);
        int internalFormat = 6408;
        int format = 6408;
        int type = 5121;
        ImageModel imageModel = textureModel.getImageModel();
        ByteBuffer imageData = imageModel.getImageData();
        PixelData pixelData = PixelDatas.create((ByteBuffer)imageData);
        if (pixelData == null) {
            logger.warning("Could not extract pixel data from image");
            pixelData = PixelDatas.createErrorPixelData();
        }
        int width = pixelData.getWidth();
        int height = pixelData.getHeight();
        ByteBuffer pixelsRGBA = pixelData.getPixelsRGBA();
        int glTexture = this.glContext.createGlTexture(pixelsRGBA, internalFormat, width, height, format, type);
        int minFilter = (Integer)Optionals.of((Object)textureModel.getMinFilter(), (Object)9986);
        int magFilter = (Integer)Optionals.of((Object)textureModel.getMagFilter(), (Object)9729);
        int wrapS = (Integer)Optionals.of((Object)textureModel.getWrapS(), (Object)10497);
        int wrapT = (Integer)Optionals.of((Object)textureModel.getWrapT(), (Object)10497);
        this.glContext.setGlTextureParameters(glTexture, minFilter, magFilter, wrapS, wrapT);
        logger.fine("Creating GL texture for texture " + textureModel + " DONE");
        return glTexture;
    }

    Integer obtainGlBufferView(BufferViewModel bufferViewModel) {
        Objects.requireNonNull(bufferViewModel, "The bufferViewModel may not be null");
        Integer glBufferView = this.bufferViewModelToGlBufferView.get(bufferViewModel);
        if (glBufferView == null && !this.bufferViewModelToGlBufferView.containsKey(bufferViewModel)) {
            glBufferView = this.createGlBufferView(bufferViewModel);
            this.bufferViewModelToGlBufferView.put(bufferViewModel, glBufferView);
        }
        return glBufferView;
    }

    private Integer createGlBufferView(BufferViewModel bufferViewModel) {
        logger.fine("Creating GL bufferView for bufferView " + bufferViewModel);
        Integer byteLength = bufferViewModel.getByteLength();
        ByteBuffer bufferViewData = bufferViewModel.getBufferViewData();
        int target = (Integer)Optionals.of((Object)bufferViewModel.getTarget(), (Object)34962);
        int glBufferView = this.glContext.createGlBufferView(target, byteLength, bufferViewData.slice());
        logger.fine("Creating GL bufferView for bufferView " + bufferViewModel + " DONE");
        return glBufferView;
    }

    void delete() {
        Collection<Integer> glTextures = this.textureModelToGlTexture.values();
        for (int glTexture : glTextures) {
            this.glContext.deleteGlTexture(glTexture);
        }
        Collection<Integer> glBufferViews = this.bufferViewModelToGlBufferView.values();
        for (int glBufferView : glBufferViews) {
            this.glContext.deleteGlBufferView(glBufferView);
        }
        Collection<Integer> glPrograms = this.programModelToGlProgram.values();
        for (int glProgram : glPrograms) {
            this.glContext.deleteGlProgram(glProgram);
        }
        for (int glVertexArray : this.glVertexArrays) {
            this.glContext.deleteGlVertexArray(glVertexArray);
        }
    }
}

