/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer;

import de.javagl.jgltf.model.v2.MaterialModelV2;
import java.util.Objects;

class MaterialStructure {
    private final String baseColorTexCoordSemantic;
    private final String metallicRoughnessTexCoordSemantic;
    private final String normalTexCoordSemantic;
    private final String occlusionTexCoordSemantic;
    private final String emissiveTexCoordSemantic;
    private final int numJoints;

    MaterialStructure(MaterialModelV2 material, int numJoints) {
        this.baseColorTexCoordSemantic = MaterialStructure.getTexCoordSemantic(material.getBaseColorTexcoord());
        this.metallicRoughnessTexCoordSemantic = MaterialStructure.getTexCoordSemantic(material.getMetallicRoughnessTexcoord());
        this.normalTexCoordSemantic = MaterialStructure.getTexCoordSemantic(material.getNormalTexcoord());
        this.occlusionTexCoordSemantic = MaterialStructure.getTexCoordSemantic(material.getOcclusionTexcoord());
        this.emissiveTexCoordSemantic = MaterialStructure.getTexCoordSemantic(material.getEmissiveTexcoord());
        this.numJoints = numJoints;
    }

    private static String getTexCoordSemantic(Integer texCoord) {
        if (texCoord == null) {
            return "TEXCOORD_0";
        }
        return "TEXCOORD_" + texCoord;
    }

    String getBaseColorTexCoordSemantic() {
        return this.baseColorTexCoordSemantic;
    }

    String getMetallicRoughnessTexCoordSemantic() {
        return this.metallicRoughnessTexCoordSemantic;
    }

    String getNormalTexCoordSemantic() {
        return this.normalTexCoordSemantic;
    }

    String getOcclusionTexCoordSemantic() {
        return this.occlusionTexCoordSemantic;
    }

    String getEmissiveTexCoordSemantic() {
        return this.emissiveTexCoordSemantic;
    }

    int getNumJoints() {
        return this.numJoints;
    }

    public int hashCode() {
        return Objects.hash(this.baseColorTexCoordSemantic, this.metallicRoughnessTexCoordSemantic, this.normalTexCoordSemantic, this.occlusionTexCoordSemantic, this.emissiveTexCoordSemantic, this.numJoints);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MaterialStructure other = (MaterialStructure)object;
        if (!Objects.equals(this.baseColorTexCoordSemantic, other.baseColorTexCoordSemantic)) {
            return false;
        }
        if (!Objects.equals(this.metallicRoughnessTexCoordSemantic, other.metallicRoughnessTexCoordSemantic)) {
            return false;
        }
        if (!Objects.equals(this.normalTexCoordSemantic, other.normalTexCoordSemantic)) {
            return false;
        }
        if (!Objects.equals(this.occlusionTexCoordSemantic, other.occlusionTexCoordSemantic)) {
            return false;
        }
        if (!Objects.equals(this.emissiveTexCoordSemantic, other.emissiveTexCoordSemantic)) {
            return false;
        }
        return this.numJoints == other.numJoints;
    }
}

