/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.viewer;

import de.javagl.jgltf.model.MathUtils;
import de.javagl.jgltf.viewer.RenderedCamera;
import java.util.Objects;
import java.util.function.Supplier;

final class ViewConfiguration {
    private RenderedCamera renderedCamera;
    private final Supplier<float[]> viewportSupplier;
    private final Supplier<float[]> viewMatrixSupplier;
    private final Supplier<float[]> projectionMatrixSupplier;

    ViewConfiguration(Supplier<float[]> viewportSupplier) {
        this.viewportSupplier = Objects.requireNonNull(viewportSupplier, "The viewportSupplier may not be null");
        this.viewMatrixSupplier = this.createViewMatrixSupplier();
        this.projectionMatrixSupplier = this.createProjectionMatrixSupplier();
    }

    public void setRenderedCamera(RenderedCamera renderedCamera) {
        this.renderedCamera = renderedCamera;
    }

    public RenderedCamera getRenderedCamera() {
        return this.renderedCamera;
    }

    private Supplier<float[]> createViewMatrixSupplier() {
        float[] defaultViewMatrix = MathUtils.createIdentity4x4();
        return () -> {
            if (this.renderedCamera == null) {
                MathUtils.setIdentity4x4((float[])defaultViewMatrix);
                return defaultViewMatrix;
            }
            return this.renderedCamera.getViewMatrix();
        };
    }

    private Supplier<float[]> createProjectionMatrixSupplier() {
        float[] defaultProjectionMatrix = MathUtils.createIdentity4x4();
        return () -> {
            if (this.renderedCamera == null) {
                MathUtils.setIdentity4x4((float[])defaultProjectionMatrix);
                return defaultProjectionMatrix;
            }
            return this.renderedCamera.getProjectionMatrix();
        };
    }

    public float[] getViewport() {
        return this.viewportSupplier.get();
    }

    public float[] getViewMatrix() {
        return this.viewMatrixSupplier.get();
    }

    public float[] getProjectionMatrix() {
        return this.projectionMatrixSupplier.get();
    }
}

