/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.arrays;

import de.javagl.nd.arrays.ArrayND;
import de.javagl.nd.arrays.Utils;
import de.javagl.nd.tuples.Order;
import de.javagl.nd.tuples.i.IntTuple;
import de.javagl.nd.tuples.i.IntTupleFunctions;
import de.javagl.nd.tuples.i.IntTuples;

public abstract class AbstractArrayND
implements ArrayND {
    private final IntTuple size;
    private final int totalSize;
    private final Order preferredIterationOrder;

    protected AbstractArrayND(IntTuple size, Order preferredIterationOrder) {
        Utils.checkForNonNegativeElements(size);
        this.size = IntTuples.copy((IntTuple)size);
        this.totalSize = IntTupleFunctions.reduce((IntTuple)size, (int)1, (a, b) -> a * b);
        this.preferredIterationOrder = preferredIterationOrder;
    }

    @Override
    public final int getTotalSize() {
        return this.totalSize;
    }

    @Override
    public final IntTuple getSize() {
        return this.size;
    }

    @Override
    public Order getPreferredIterationOrder() {
        return this.preferredIterationOrder;
    }
}

