/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.arrays;

import de.javagl.nd.iteration.tuples.i.IntTupleStreams;
import de.javagl.nd.tuples.Order;
import de.javagl.nd.tuples.i.IntTuple;
import de.javagl.nd.tuples.i.MutableIntTuple;
import java.util.stream.Stream;

public class Coordinates {
    public static Stream<MutableIntTuple> coordinates(IntTuple arraySize) {
        return IntTupleStreams.lexicographicalStream((IntTuple)arraySize);
    }

    public static Stream<MutableIntTuple> coordinates(Order order, IntTuple arraySize) {
        if (order == Order.COLEXICOGRAPHICAL) {
            return Coordinates.colexicographicalCoordinates(arraySize);
        }
        return Coordinates.lexicographicalCoordinates(arraySize);
    }

    public static Stream<MutableIntTuple> lexicographicalCoordinates(IntTuple arraySize) {
        return IntTupleStreams.lexicographicalStream((IntTuple)arraySize);
    }

    public static Stream<MutableIntTuple> colexicographicalCoordinates(IntTuple arraySize) {
        return IntTupleStreams.colexicographicalStream((IntTuple)arraySize);
    }

    private Coordinates() {
    }
}

