/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.arrays;

import de.javagl.nd.tuples.Order;
import de.javagl.nd.tuples.i.IntTuple;
import de.javagl.nd.tuples.i.IntTupleFunctions;
import de.javagl.nd.tuples.i.IntTuples;
import de.javagl.nd.tuples.i.MutableIntTuple;
import java.util.Objects;
import java.util.function.ToIntFunction;

public class Indexers {
    public static ToIntFunction<IntTuple> indexer(Order order, IntTuple size) {
        if (order == Order.COLEXICOGRAPHICAL) {
            return Indexers.colexicographicalIndexer(size);
        }
        return Indexers.lexicographicalIndexer(size);
    }

    public static ToIntFunction<IntTuple> lexicographicalIndexer(IntTuple size) {
        Objects.requireNonNull(size, "The size is null");
        MutableIntTuple reversedProducts = IntTupleFunctions.exclusiveScan((IntTuple)IntTuples.reversed((IntTuple)size), (int)1, (a, b) -> a * b, null);
        MutableIntTuple sizeProducts = IntTuples.reverse((IntTuple)reversedProducts, null);
        return arg_0 -> Indexers.lambda$lexicographicalIndexer$11((IntTuple)sizeProducts, arg_0);
    }

    public static ToIntFunction<IntTuple> colexicographicalIndexer(IntTuple size) {
        Objects.requireNonNull(size, "The size is null");
        MutableIntTuple sizeProducts = IntTupleFunctions.exclusiveScan((IntTuple)size, (int)1, (a, b) -> a * b, null);
        return arg_0 -> Indexers.lambda$colexicographicalIndexer$13((IntTuple)sizeProducts, arg_0);
    }

    private Indexers() {
    }

    private static /* synthetic */ int lambda$colexicographicalIndexer$13(IntTuple intTuple, IntTuple indices) {
        return IntTuples.dot((IntTuple)indices, (IntTuple)intTuple);
    }

    private static /* synthetic */ int lambda$lexicographicalIndexer$11(IntTuple intTuple, IntTuple indices) {
        return IntTuples.dot((IntTuple)indices, (IntTuple)intTuple);
    }
}

