/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.arrays;

import de.javagl.nd.arrays.ArrayND;
import de.javagl.nd.tuples.i.IntTuple;

public class Utils {
    public static void checkForEqualDimensions(ArrayND a0, ArrayND a1) {
        if (a0.getSize().getSize() != a1.getSize().getSize()) {
            throw new IllegalArgumentException("Arrays have different dimensions: " + a0.getSize().getSize() + " and " + a1.getSize().getSize());
        }
    }

    public static void checkForEqualSizes(ArrayND a0, ArrayND a1) {
        if (!a0.getSize().equals((Object)a1.getSize())) {
            throw new IllegalArgumentException("Arrays have different sizes: " + a0.getSize() + " and " + a1.getSize());
        }
    }

    public static void checkForNonNegativeElements(IntTuple t) {
        for (int i = 0; i < t.getSize(); ++i) {
            if (t.get(i) >= 0) continue;
            throw new IllegalArgumentException("Negative size: " + t);
        }
    }

    public static void checkForValidSubArrayIndices(IntTuple parentSize, IntTuple fromIndices, IntTuple toIndices) {
        if (fromIndices.getSize() != parentSize.getSize()) {
            throw new IllegalArgumentException("Parent is " + parentSize.getSize() + "-dimensional, " + "but fromIndices is " + fromIndices.getSize() + "-dimensional");
        }
        if (toIndices.getSize() != parentSize.getSize()) {
            throw new IllegalArgumentException("Parent is " + parentSize.getSize() + "-dimensional, " + "but toIndices is " + toIndices.getSize() + "-dimensional");
        }
        int n = parentSize.getSize();
        for (int i = 0; i < n; ++i) {
            int p = parentSize.get(i);
            int f = fromIndices.get(i);
            int t = toIndices.get(i);
            if (f >= 0 && t <= p && f <= t) continue;
            throw new IllegalArgumentException("Invalid index range: " + fromIndices + " to " + toIndices + " in " + parentSize);
        }
    }

    public static int countDifferences(IntTuple t0, IntTuple t1) {
        if (t0.getSize() != t1.getSize()) {
            throw new IllegalArgumentException("Sizes do not match: " + t0.getSize() + " and " + t1.getSize());
        }
        int n = t0.getSize();
        int differences = 0;
        for (int i = 0; i < n; ++i) {
            if (t0.get(i) == t1.get(i)) continue;
            ++differences;
        }
        return differences;
    }
}

