/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.arrays.d;

import de.javagl.nd.arrays.Utils;
import de.javagl.nd.arrays.d.DoubleArrayND;
import de.javagl.nd.arrays.d.DoubleArraysND;
import de.javagl.nd.arrays.d.MutableDoubleArrayND;
import de.javagl.nd.tuples.i.IntTuple;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Stream;

public class DoubleArrayFunctionsND {
    public static void set(MutableDoubleArrayND a0, DoubleSupplier s) {
        ((Stream)a0.coordinates().parallel()).forEach(t -> a0.set((IntTuple)t, s.getAsDouble()));
    }

    public static MutableDoubleArrayND apply(DoubleArrayND a0, DoubleArrayND a1, DoubleBinaryOperator op, MutableDoubleArrayND result) {
        Utils.checkForEqualSizes(a0, a1);
        MutableDoubleArrayND finalResult = DoubleArrayFunctionsND.validate(a0, result);
        ((Stream)finalResult.coordinates().parallel()).forEach(t -> {
            double operand0 = a0.get((IntTuple)t);
            double operand1 = a1.get((IntTuple)t);
            double r = op.applyAsDouble(operand0, operand1);
            finalResult.set((IntTuple)t, r);
        });
        return finalResult;
    }

    public static MutableDoubleArrayND apply(DoubleArrayND a0, DoubleUnaryOperator op, MutableDoubleArrayND result) {
        MutableDoubleArrayND finalResult = DoubleArrayFunctionsND.validate(a0, result);
        ((Stream)finalResult.coordinates().parallel()).forEach(t -> {
            double operand0 = a0.get((IntTuple)t);
            double r = op.applyAsDouble(operand0);
            finalResult.set((IntTuple)t, r);
        });
        return finalResult;
    }

    private static MutableDoubleArrayND validate(DoubleArrayND a, MutableDoubleArrayND result) {
        if (result == null) {
            result = DoubleArraysND.create(a.getSize());
        } else {
            Utils.checkForEqualSizes(a, result);
        }
        return result;
    }

    private DoubleArrayFunctionsND() {
    }
}

