/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.arrays.d;

import de.javagl.nd.arrays.Coordinates;
import de.javagl.nd.arrays.Utils;
import de.javagl.nd.arrays.d.ArrayDoubleArray2D;
import de.javagl.nd.arrays.d.DefaultDoubleArrayND;
import de.javagl.nd.arrays.d.DoubleArrayND;
import de.javagl.nd.arrays.d.MutableDoubleArrayND;
import de.javagl.nd.arrays.d.MutableSubDoubleArrayND;
import de.javagl.nd.arrays.d.MutableTupleDoubleArrayND;
import de.javagl.nd.arrays.d.SubDoubleArrayND;
import de.javagl.nd.arrays.d.TupleDoubleArrayND;
import de.javagl.nd.iteration.tuples.i.IntTupleIterables;
import de.javagl.nd.tuples.d.DoubleTuple;
import de.javagl.nd.tuples.d.MutableDoubleTuple;
import de.javagl.nd.tuples.i.IntTuple;
import de.javagl.nd.tuples.i.IntTupleFunctions;
import de.javagl.nd.tuples.i.IntTuples;
import de.javagl.nd.tuples.i.MutableIntTuple;
import java.util.Objects;
import java.util.function.ToDoubleFunction;
import java.util.stream.Stream;

public class DoubleArraysND {
    public static MutableDoubleArrayND create(IntTuple size) {
        return new DefaultDoubleArrayND(size);
    }

    public static MutableDoubleArrayND create(int ... size) {
        return DoubleArraysND.create((IntTuple)IntTuples.wrap((int[])size));
    }

    public static MutableDoubleArrayND wrap(double[][] array) {
        return new ArrayDoubleArray2D(array);
    }

    public static DoubleArrayND wrap(DoubleTuple t, IntTuple size) {
        Objects.requireNonNull(t, "The tuple is null");
        Objects.requireNonNull(size, "The size is null");
        int totalSize = IntTupleFunctions.reduce((IntTuple)size, (int)1, (a, b) -> a * b);
        if (t.getSize() != totalSize) {
            throw new IllegalArgumentException("The tuple has a size of " + t.getSize() + ", the expected " + "array size is " + size + " (total: " + totalSize + ")");
        }
        return new TupleDoubleArrayND(t, size);
    }

    public static MutableDoubleArrayND wrap(MutableDoubleTuple t, IntTuple size) {
        Objects.requireNonNull(t, "The tuple is null");
        Objects.requireNonNull(size, "The size is null");
        int totalSize = IntTupleFunctions.reduce((IntTuple)size, (int)1, (a, b) -> a * b);
        if (t.getSize() != totalSize) {
            throw new IllegalArgumentException("The tuple has a size of " + t.getSize() + ", the expected " + "array size is " + size + " (total: " + totalSize + ")");
        }
        return new MutableTupleDoubleArrayND(t, size);
    }

    public static ToDoubleFunction<IntTuple> asFunction(final DoubleArrayND array) {
        Objects.requireNonNull(array, "The array is null");
        return new ToDoubleFunction<IntTuple>(){

            @Override
            public double applyAsDouble(IntTuple s) {
                return array.get(s);
            }
        };
    }

    public static DoubleArrayND createSubArray(DoubleArrayND parent, IntTuple fromIndices, IntTuple toIndices) {
        return new SubDoubleArrayND(parent, fromIndices, toIndices);
    }

    public static MutableDoubleArrayND createSubArray(MutableDoubleArrayND parent, IntTuple fromIndices, IntTuple toIndices) {
        return new MutableSubDoubleArrayND(parent, fromIndices, toIndices);
    }

    public static double min(DoubleArrayND array) {
        return array.stream().parallel().reduce(Double.POSITIVE_INFINITY, Math::min);
    }

    public static double max(DoubleArrayND array) {
        return array.stream().parallel().reduce(Double.NEGATIVE_INFINITY, Math::max);
    }

    static String toString(DoubleArrayND array) {
        if (array == null) {
            return "null";
        }
        return array.getClass().getSimpleName() + "[size=" + array.getSize() + "]";
    }

    static int hashCode(DoubleArrayND array) {
        if (array == null) {
            return 0;
        }
        return array.stream().parallel().mapToInt(Double::hashCode).sum();
    }

    static boolean equals(DoubleArrayND array, Object object) {
        if (array == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DoubleArrayND)) {
            return false;
        }
        DoubleArrayND other = (DoubleArrayND)object;
        if (!array.getSize().equals((Object)other.getSize())) {
            return false;
        }
        Stream<MutableIntTuple> coordinates = Coordinates.coordinates(array.getPreferredIterationOrder(), array.getSize());
        Iterable iterable = () -> coordinates.iterator();
        for (IntTuple coordinate : iterable) {
            double otherValue;
            double arrayValue = array.get(coordinate);
            if (arrayValue == (otherValue = other.get(coordinate))) continue;
            return false;
        }
        return true;
    }

    public static String toFormattedString(DoubleArrayND array) {
        return DoubleArraysND.toFormattedString(array, "%f");
    }

    public static String toFormattedString(DoubleArrayND array, String format) {
        if (array == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        Iterable iterable = IntTupleIterables.lexicographicalIterable((IntTuple)array.getSize());
        IntTuple previous = null;
        for (IntTuple coordinates : iterable) {
            if (previous != null) {
                int c = Utils.countDifferences(previous, coordinates);
                for (int i = 0; i < c - 1; ++i) {
                    sb.append("\n");
                }
            }
            double value = array.get(coordinates);
            sb.append(String.format(format + ", ", value));
            previous = coordinates;
        }
        return sb.toString();
    }

    private DoubleArraysND() {
    }
}

