/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.arrays.i;

import de.javagl.nd.arrays.i.AbstractMutableIntArrayND;
import de.javagl.nd.arrays.i.MutableIntArrayND;
import de.javagl.nd.tuples.Order;
import de.javagl.nd.tuples.i.IntTuple;
import de.javagl.nd.tuples.i.IntTuples;

class ArrayIntArray2D
extends AbstractMutableIntArrayND
implements MutableIntArrayND {
    private final int[][] array;

    ArrayIntArray2D(int[][] array) {
        super((IntTuple)(array.length == 0 ? IntTuples.of((int)0, (int)0) : IntTuples.of((int)array.length, (int)array[0].length)), Order.LEXICOGRAPHICAL);
        this.array = array;
    }

    @Override
    public int get(IntTuple coordinates) {
        if (coordinates.getSize() != 2) {
            throw new IllegalArgumentException("Using " + coordinates.getSize() + "-dimensional " + "coordinates for accessing a 2-dimensional array");
        }
        int x = coordinates.get(0);
        int y = coordinates.get(1);
        return this.array[x][y];
    }

    @Override
    public void set(IntTuple coordinates, int value) {
        if (coordinates.getSize() != 2) {
            throw new IllegalArgumentException("Using " + coordinates.getSize() + "-dimensional " + "coordinates for accessing a 2-dimensional array");
        }
        int x = coordinates.get(0);
        int y = coordinates.get(1);
        this.array[x][y] = value;
    }
}

