/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.arrays.i;

import de.javagl.nd.arrays.Utils;
import de.javagl.nd.arrays.i.IntArrayND;
import de.javagl.nd.arrays.i.IntArraysND;
import de.javagl.nd.arrays.i.MutableIntArrayND;
import de.javagl.nd.tuples.i.IntTuple;
import java.util.function.IntBinaryOperator;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import java.util.stream.Stream;

public class IntArrayFunctionsND {
    public static void set(MutableIntArrayND a0, IntSupplier s) {
        ((Stream)a0.coordinates().parallel()).forEach(t -> a0.set((IntTuple)t, s.getAsInt()));
    }

    public static MutableIntArrayND apply(IntArrayND a0, IntArrayND a1, IntBinaryOperator op, MutableIntArrayND result) {
        Utils.checkForEqualSizes(a0, a1);
        MutableIntArrayND finalResult = IntArrayFunctionsND.validate(a0, result);
        ((Stream)finalResult.coordinates().parallel()).forEach(t -> {
            int operand0 = a0.get((IntTuple)t);
            int operand1 = a1.get((IntTuple)t);
            int r = op.applyAsInt(operand0, operand1);
            finalResult.set((IntTuple)t, r);
        });
        return finalResult;
    }

    public static MutableIntArrayND apply(IntArrayND a0, IntUnaryOperator op, MutableIntArrayND result) {
        MutableIntArrayND finalResult = IntArrayFunctionsND.validate(a0, result);
        ((Stream)finalResult.coordinates().parallel()).forEach(t -> {
            int operand0 = a0.get((IntTuple)t);
            int r = op.applyAsInt(operand0);
            finalResult.set((IntTuple)t, r);
        });
        return finalResult;
    }

    private static MutableIntArrayND validate(IntArrayND a, MutableIntArrayND result) {
        if (result == null) {
            result = IntArraysND.create(a.getSize());
        } else {
            Utils.checkForEqualSizes(a, result);
        }
        return result;
    }

    private IntArrayFunctionsND() {
    }
}

