/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.arrays.i;

import de.javagl.nd.arrays.Coordinates;
import de.javagl.nd.arrays.Utils;
import de.javagl.nd.arrays.i.ArrayIntArray2D;
import de.javagl.nd.arrays.i.DefaultIntArrayND;
import de.javagl.nd.arrays.i.IntArrayND;
import de.javagl.nd.arrays.i.MutableIntArrayND;
import de.javagl.nd.arrays.i.MutableSubIntArrayND;
import de.javagl.nd.arrays.i.MutableTupleIntArrayND;
import de.javagl.nd.arrays.i.SubIntArrayND;
import de.javagl.nd.arrays.i.TupleIntArrayND;
import de.javagl.nd.iteration.tuples.i.IntTupleIterables;
import de.javagl.nd.tuples.i.IntTuple;
import de.javagl.nd.tuples.i.IntTupleFunctions;
import de.javagl.nd.tuples.i.IntTuples;
import de.javagl.nd.tuples.i.MutableIntTuple;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;

public class IntArraysND {
    public static MutableIntArrayND create(IntTuple size) {
        return new DefaultIntArrayND(size);
    }

    public static MutableIntArrayND create(int ... size) {
        return IntArraysND.create((IntTuple)IntTuples.wrap((int[])size));
    }

    public static MutableIntArrayND wrap(int[][] array) {
        return new ArrayIntArray2D(array);
    }

    public static IntArrayND wrap(IntTuple t, IntTuple size) {
        Objects.requireNonNull(t, "The tuple is null");
        Objects.requireNonNull(size, "The size is null");
        int totalSize = IntTupleFunctions.reduce((IntTuple)size, (int)1, (a, b) -> a * b);
        if (t.getSize() != totalSize) {
            throw new IllegalArgumentException("The tuple has a size of " + t.getSize() + ", the expected " + "array size is " + size + " (total: " + totalSize + ")");
        }
        return new TupleIntArrayND(t, size);
    }

    public static MutableIntArrayND wrap(MutableIntTuple t, IntTuple size) {
        Objects.requireNonNull(t, "The tuple is null");
        Objects.requireNonNull(size, "The size is null");
        int totalSize = IntTupleFunctions.reduce((IntTuple)size, (int)1, (a, b) -> a * b);
        if (t.getSize() != totalSize) {
            throw new IllegalArgumentException("The tuple has a size of " + t.getSize() + ", the expected " + "array size is " + size + " (total: " + totalSize + ")");
        }
        return new MutableTupleIntArrayND(t, size);
    }

    public static ToIntFunction<IntTuple> asFunction(final IntArrayND array) {
        Objects.requireNonNull(array, "The array is null");
        return new ToIntFunction<IntTuple>(){

            @Override
            public int applyAsInt(IntTuple s) {
                return array.get(s);
            }
        };
    }

    public static IntArrayND createSubArray(IntArrayND parent, IntTuple fromIndices, IntTuple toIndices) {
        return new SubIntArrayND(parent, fromIndices, toIndices);
    }

    public static MutableIntArrayND createSubArray(MutableIntArrayND parent, IntTuple fromIndices, IntTuple toIndices) {
        return new MutableSubIntArrayND(parent, fromIndices, toIndices);
    }

    public static int min(IntArrayND array) {
        return array.stream().parallel().reduce(Integer.MAX_VALUE, Math::min);
    }

    public static int max(IntArrayND array) {
        return array.stream().parallel().reduce(Integer.MIN_VALUE, Math::max);
    }

    static String toString(IntArrayND array) {
        if (array == null) {
            return "null";
        }
        return array.getClass().getSimpleName() + "[size=" + array.getSize() + "]";
    }

    static int hashCode(IntArrayND array) {
        if (array == null) {
            return 0;
        }
        return array.stream().parallel().sum();
    }

    static boolean equals(IntArrayND array, Object object) {
        if (array == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof IntArrayND)) {
            return false;
        }
        IntArrayND other = (IntArrayND)object;
        if (!array.getSize().equals((Object)other.getSize())) {
            return false;
        }
        Stream<MutableIntTuple> coordinates = Coordinates.coordinates(array.getPreferredIterationOrder(), array.getSize());
        Iterable iterable = () -> coordinates.iterator();
        for (IntTuple coordinate : iterable) {
            int otherValue;
            int arrayValue = array.get(coordinate);
            if (arrayValue == (otherValue = other.get(coordinate))) continue;
            return false;
        }
        return true;
    }

    public static String toFormattedString(IntArrayND array) {
        return IntArraysND.toFormattedString(array, "%f");
    }

    public static String toFormattedString(IntArrayND array, String format) {
        if (array == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        Iterable iterable = IntTupleIterables.lexicographicalIterable((IntTuple)array.getSize());
        IntTuple previous = null;
        for (IntTuple coordinates : iterable) {
            if (previous != null) {
                int c = Utils.countDifferences(previous, coordinates);
                for (int i = 0; i < c - 1; ++i) {
                    sb.append("\n");
                }
            }
            int value = array.get(coordinates);
            sb.append(String.format(format + ", ", value));
            previous = coordinates;
        }
        return sb.toString();
    }

    private IntArraysND() {
    }
}

