/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.arrays.i;

import de.javagl.nd.arrays.Indexers;
import de.javagl.nd.arrays.i.AbstractMutableIntArrayND;
import de.javagl.nd.arrays.i.MutableIntArrayND;
import de.javagl.nd.tuples.Order;
import de.javagl.nd.tuples.i.IntTuple;
import de.javagl.nd.tuples.i.MutableIntTuple;
import java.util.Objects;
import java.util.function.ToIntFunction;

class MutableTupleIntArrayND
extends AbstractMutableIntArrayND
implements MutableIntArrayND {
    private final MutableIntTuple data;
    private final ToIntFunction<IntTuple> indexer;

    MutableTupleIntArrayND(MutableIntTuple data, IntTuple size) {
        super(size, Order.LEXICOGRAPHICAL);
        Objects.requireNonNull(data, "The data is null");
        this.data = data;
        this.indexer = Indexers.lexicographicalIndexer(size);
    }

    @Override
    public int get(IntTuple indices) {
        return this.data.get(this.indexer.applyAsInt(indices));
    }

    @Override
    public void set(IntTuple indices, int value) {
        this.data.set(this.indexer.applyAsInt(indices), value);
    }
}

