/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.arrays.j;

import de.javagl.nd.arrays.j.AbstractMutableLongArrayND;
import de.javagl.nd.arrays.j.MutableLongArrayND;
import de.javagl.nd.tuples.Order;
import de.javagl.nd.tuples.i.IntTuple;
import de.javagl.nd.tuples.i.IntTuples;

class ArrayLongArray2D
extends AbstractMutableLongArrayND
implements MutableLongArrayND {
    private final long[][] array;

    ArrayLongArray2D(long[][] array) {
        super((IntTuple)(array.length == 0 ? IntTuples.of((int)0, (int)0) : IntTuples.of((int)array.length, (int)array[0].length)), Order.LEXICOGRAPHICAL);
        this.array = array;
    }

    @Override
    public long get(IntTuple coordinates) {
        if (coordinates.getSize() != 2) {
            throw new IllegalArgumentException("Using " + coordinates.getSize() + "-dimensional " + "coordinates for accessing a 2-dimensional array");
        }
        int x = coordinates.get(0);
        int y = coordinates.get(1);
        return this.array[x][y];
    }

    @Override
    public void set(IntTuple coordinates, long value) {
        if (coordinates.getSize() != 2) {
            throw new IllegalArgumentException("Using " + coordinates.getSize() + "-dimensional " + "coordinates for accessing a 2-dimensional array");
        }
        int x = coordinates.get(0);
        int y = coordinates.get(1);
        this.array[x][y] = value;
    }
}

