/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.arrays.j;

import de.javagl.nd.arrays.Utils;
import de.javagl.nd.arrays.j.LongArrayND;
import de.javagl.nd.arrays.j.LongArraysND;
import de.javagl.nd.arrays.j.MutableLongArrayND;
import de.javagl.nd.tuples.i.IntTuple;
import java.util.function.LongBinaryOperator;
import java.util.function.LongSupplier;
import java.util.function.LongUnaryOperator;
import java.util.stream.Stream;

public class LongArrayFunctionsND {
    public static void set(MutableLongArrayND a0, LongSupplier s) {
        ((Stream)a0.coordinates().parallel()).forEach(t -> a0.set((IntTuple)t, s.getAsLong()));
    }

    public static MutableLongArrayND apply(LongArrayND a0, LongArrayND a1, LongBinaryOperator op, MutableLongArrayND result) {
        Utils.checkForEqualSizes(a0, a1);
        MutableLongArrayND finalResult = LongArrayFunctionsND.validate(a0, result);
        ((Stream)finalResult.coordinates().parallel()).forEach(t -> {
            long operand0 = a0.get((IntTuple)t);
            long operand1 = a1.get((IntTuple)t);
            long r = op.applyAsLong(operand0, operand1);
            finalResult.set((IntTuple)t, r);
        });
        return finalResult;
    }

    public static MutableLongArrayND apply(LongArrayND a0, LongUnaryOperator op, MutableLongArrayND result) {
        MutableLongArrayND finalResult = LongArrayFunctionsND.validate(a0, result);
        ((Stream)finalResult.coordinates().parallel()).forEach(t -> {
            long operand0 = a0.get((IntTuple)t);
            long r = op.applyAsLong(operand0);
            finalResult.set((IntTuple)t, r);
        });
        return finalResult;
    }

    private static MutableLongArrayND validate(LongArrayND a, MutableLongArrayND result) {
        if (result == null) {
            result = LongArraysND.create(a.getSize());
        } else {
            Utils.checkForEqualSizes(a, result);
        }
        return result;
    }

    private LongArrayFunctionsND() {
    }
}

