/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.arrays.j;

import de.javagl.nd.arrays.Coordinates;
import de.javagl.nd.arrays.Utils;
import de.javagl.nd.arrays.j.ArrayLongArray2D;
import de.javagl.nd.arrays.j.DefaultLongArrayND;
import de.javagl.nd.arrays.j.LongArrayND;
import de.javagl.nd.arrays.j.MutableLongArrayND;
import de.javagl.nd.arrays.j.MutableSubLongArrayND;
import de.javagl.nd.arrays.j.MutableTupleLongArrayND;
import de.javagl.nd.arrays.j.SubLongArrayND;
import de.javagl.nd.arrays.j.TupleLongArrayND;
import de.javagl.nd.iteration.tuples.i.IntTupleIterables;
import de.javagl.nd.tuples.i.IntTuple;
import de.javagl.nd.tuples.i.IntTupleFunctions;
import de.javagl.nd.tuples.i.IntTuples;
import de.javagl.nd.tuples.i.MutableIntTuple;
import de.javagl.nd.tuples.j.LongTuple;
import de.javagl.nd.tuples.j.MutableLongTuple;
import java.util.Objects;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;

public class LongArraysND {
    public static MutableLongArrayND create(IntTuple size) {
        return new DefaultLongArrayND(size);
    }

    public static MutableLongArrayND create(int ... size) {
        return LongArraysND.create((IntTuple)IntTuples.wrap((int[])size));
    }

    public static MutableLongArrayND wrap(long[][] array) {
        return new ArrayLongArray2D(array);
    }

    public static LongArrayND wrap(LongTuple t, IntTuple size) {
        Objects.requireNonNull(t, "The tuple is null");
        Objects.requireNonNull(size, "The size is null");
        int totalSize = IntTupleFunctions.reduce((IntTuple)size, (int)1, (a, b) -> a * b);
        if (t.getSize() != totalSize) {
            throw new IllegalArgumentException("The tuple has a size of " + t.getSize() + ", the expected " + "array size is " + size + " (total: " + totalSize + ")");
        }
        return new TupleLongArrayND(t, size);
    }

    public static MutableLongArrayND wrap(MutableLongTuple t, IntTuple size) {
        Objects.requireNonNull(t, "The tuple is null");
        Objects.requireNonNull(size, "The size is null");
        int totalSize = IntTupleFunctions.reduce((IntTuple)size, (int)1, (a, b) -> a * b);
        if (t.getSize() != totalSize) {
            throw new IllegalArgumentException("The tuple has a size of " + t.getSize() + ", the expected " + "array size is " + size + " (total: " + totalSize + ")");
        }
        return new MutableTupleLongArrayND(t, size);
    }

    public static ToLongFunction<IntTuple> asFunction(final LongArrayND array) {
        Objects.requireNonNull(array, "The array is null");
        return new ToLongFunction<IntTuple>(){

            @Override
            public long applyAsLong(IntTuple s) {
                return array.get(s);
            }
        };
    }

    public static LongArrayND createSubArray(LongArrayND parent, IntTuple fromIndices, IntTuple toIndices) {
        return new SubLongArrayND(parent, fromIndices, toIndices);
    }

    public static MutableLongArrayND createSubArray(MutableLongArrayND parent, IntTuple fromIndices, IntTuple toIndices) {
        return new MutableSubLongArrayND(parent, fromIndices, toIndices);
    }

    public static long min(LongArrayND array) {
        return array.stream().parallel().reduce(Long.MAX_VALUE, Math::min);
    }

    public static long max(LongArrayND array) {
        return array.stream().parallel().reduce(Long.MIN_VALUE, Math::max);
    }

    static String toString(LongArrayND array) {
        if (array == null) {
            return "null";
        }
        return array.getClass().getSimpleName() + "[size=" + array.getSize() + "]";
    }

    static int hashCode(LongArrayND array) {
        if (array == null) {
            return 0;
        }
        return array.stream().parallel().mapToInt(Long::hashCode).sum();
    }

    static boolean equals(LongArrayND array, Object object) {
        if (array == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof LongArrayND)) {
            return false;
        }
        LongArrayND other = (LongArrayND)object;
        if (!array.getSize().equals((Object)other.getSize())) {
            return false;
        }
        Stream<MutableIntTuple> coordinates = Coordinates.coordinates(array.getPreferredIterationOrder(), array.getSize());
        Iterable iterable = () -> coordinates.iterator();
        for (IntTuple coordinate : iterable) {
            long otherValue;
            long arrayValue = array.get(coordinate);
            if (arrayValue == (otherValue = other.get(coordinate))) continue;
            return false;
        }
        return true;
    }

    public static String toFormattedString(LongArrayND array) {
        return LongArraysND.toFormattedString(array, "%f");
    }

    public static String toFormattedString(LongArrayND array, String format) {
        if (array == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        Iterable iterable = IntTupleIterables.lexicographicalIterable((IntTuple)array.getSize());
        IntTuple previous = null;
        for (IntTuple coordinates : iterable) {
            if (previous != null) {
                int c = Utils.countDifferences(previous, coordinates);
                for (int i = 0; i < c - 1; ++i) {
                    sb.append("\n");
                }
            }
            long value = array.get(coordinates);
            sb.append(String.format(format + ", ", value));
            previous = coordinates;
        }
        return sb.toString();
    }

    private LongArraysND() {
    }
}

