/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.distance.tuples.d;

import de.javagl.nd.distance.DistanceFunction;
import de.javagl.nd.distance.tuples.d.DoubleTupleDistanceFunctionAngular;
import de.javagl.nd.distance.tuples.d.DoubleTupleDistanceFunctionDynamicTimeWarping;
import de.javagl.nd.distance.tuples.d.DoubleTupleDistanceFunctionEuclidean;
import de.javagl.nd.distance.tuples.d.DoubleTupleDistanceFunctionEuclideanSquared;
import de.javagl.nd.tuples.Tuple;
import de.javagl.nd.tuples.Utils;
import de.javagl.nd.tuples.d.DoubleTuple;
import de.javagl.nd.tuples.d.DoubleTuples;
import de.javagl.nd.tuples.d.MutableDoubleTuple;
import java.util.Comparator;
import java.util.function.ToDoubleBiFunction;

public class DoubleTupleDistanceFunctions {
    public static Comparator<DoubleTuple> byDistanceComparator(DoubleTuple reference, final ToDoubleBiFunction<? super DoubleTuple, ? super DoubleTuple> distanceFunction) {
        MutableDoubleTuple fReference = DoubleTuples.copy((DoubleTuple)reference);
        return new Comparator<DoubleTuple>((DoubleTuple)fReference){
            final /* synthetic */ DoubleTuple val$fReference;
            {
                this.val$fReference = doubleTuple;
            }

            @Override
            public int compare(DoubleTuple t0, DoubleTuple t1) {
                double d0 = distanceFunction.applyAsDouble(this.val$fReference, t0);
                double d1 = distanceFunction.applyAsDouble(this.val$fReference, t1);
                return Double.compare(d0, d1);
            }
        };
    }

    public static DistanceFunction<DoubleTuple> euclidean() {
        return new DoubleTupleDistanceFunctionEuclidean();
    }

    public static DistanceFunction<DoubleTuple> euclideanSquared() {
        return new DoubleTupleDistanceFunctionEuclideanSquared();
    }

    public static double computeEuclidean(DoubleTuple t0, DoubleTuple t1) {
        return Math.sqrt(DoubleTupleDistanceFunctions.computeEuclideanSquared(t0, t1));
    }

    public static double computeEuclideanSquared(DoubleTuple t0, DoubleTuple t1) {
        Utils.checkForEqualSize((Tuple)t0, (Tuple)t1);
        double sum = 0.0;
        int n = t0.getSize();
        for (int i = 0; i < n; ++i) {
            double value0 = t0.get(i);
            double value1 = t1.get(i);
            double d = value1 - value0;
            double dd = d * d;
            sum += dd;
        }
        return sum;
    }

    public static DistanceFunction<DoubleTuple> angular() {
        return new DoubleTupleDistanceFunctionAngular();
    }

    private static double computeCosineSimilarity(DoubleTuple t0, DoubleTuple t1) {
        Utils.checkForEqualSize((Tuple)t0, (Tuple)t1);
        double dot = DoubleTuples.dot((DoubleTuple)t0, (DoubleTuple)t1);
        double epsilon = 1.0E-10;
        if (Math.abs(dot) < 1.0E-10) {
            return 0.0;
        }
        double tt0 = DoubleTuples.computeL2((DoubleTuple)t0);
        double tt1 = DoubleTuples.computeL2((DoubleTuple)t1);
        double tt = tt0 * tt1;
        double result = DoubleTupleDistanceFunctions.clamp(dot / tt, -1.0, 1.0);
        return result;
    }

    private static double clamp(double d, double min, double max) {
        if (d < min) {
            return min;
        }
        if (d > max) {
            return max;
        }
        return d;
    }

    static double computeAngularSimilarity(DoubleTuple t0, DoubleTuple t1) {
        return 1.0 - Math.acos(DoubleTupleDistanceFunctions.computeCosineSimilarity(t0, t1)) / Math.PI;
    }

    public static DistanceFunction<DoubleTuple> dynamicTimeWarping() {
        return new DoubleTupleDistanceFunctionDynamicTimeWarping();
    }

    private DoubleTupleDistanceFunctions() {
    }
}

