/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.distance.tuples.d;

import de.javagl.nd.tuples.d.DoubleTuple;

class DynamicTimeWarpingDistance {
    private static final ThreadLocal<double[][]> threadLocalMatrix = new ThreadLocal<double[][]>(){

        @Override
        protected double[][] initialValue() {
            return new double[1][1];
        }
    };

    static double computeDynamicTimeWarpingDistance(DoubleTuple u, DoubleTuple v) {
        int i;
        int m = u.getSize();
        int n = v.getSize();
        double[][] matrix = threadLocalMatrix.get();
        if (matrix.length < m || matrix[0].length < n) {
            matrix = new double[m][n];
            threadLocalMatrix.set(matrix);
        }
        double u0 = u.get(0);
        double v0 = v.get(0);
        matrix[0][0] = Math.abs(u0 - v0);
        for (int j = 1; j < n; ++j) {
            matrix[0][j] = Math.abs(u0 - v.get(j)) + matrix[0][j - 1];
        }
        for (i = 1; i < m; ++i) {
            matrix[i][0] = Math.abs(u.get(i) - v0) + matrix[i - 1][0];
        }
        for (i = 1; i < m; ++i) {
            double ui = u.get(i);
            for (int j = 1; j < n; ++j) {
                double vj = v.get(j);
                double min = matrix[i - 1][j - 1];
                min = DynamicTimeWarpingDistance.min(min, matrix[i][j - 1]);
                min = DynamicTimeWarpingDistance.min(min, matrix[i - 1][j]);
                double d = ui - vj;
                matrix[i][j] = min + (d < 0.0 ? -d : d);
            }
        }
        return matrix[m - 1][n - 1];
    }

    private static double min(double d0, double d1) {
        return d0 < d1 ? d0 : d1;
    }

    private DynamicTimeWarpingDistance() {
    }
}

