/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.distance.tuples.i;

import de.javagl.nd.distance.DistanceFunction;
import de.javagl.nd.distance.tuples.i.IntTupleDistanceFunctionChebyshev;
import de.javagl.nd.distance.tuples.i.IntTupleDistanceFunctionChebyshevWrapped;
import de.javagl.nd.distance.tuples.i.IntTupleDistanceFunctionEuclidean;
import de.javagl.nd.distance.tuples.i.IntTupleDistanceFunctionEuclideanSquared;
import de.javagl.nd.distance.tuples.i.IntTupleDistanceFunctionEuclideanSquaredWrapped;
import de.javagl.nd.distance.tuples.i.IntTupleDistanceFunctionEuclideanWrapped;
import de.javagl.nd.distance.tuples.i.IntTupleDistanceFunctionManhattan;
import de.javagl.nd.distance.tuples.i.IntTupleDistanceFunctionManhattanWrapped;
import de.javagl.nd.distance.tuples.i.MathUtils;
import de.javagl.nd.tuples.Tuple;
import de.javagl.nd.tuples.Utils;
import de.javagl.nd.tuples.i.IntTuple;
import de.javagl.nd.tuples.i.IntTuples;
import de.javagl.nd.tuples.i.MutableIntTuple;
import java.util.Comparator;
import java.util.function.ToDoubleBiFunction;

public class IntTupleDistanceFunctions {
    public static Comparator<IntTuple> byDistanceComparator(IntTuple reference, final ToDoubleBiFunction<? super IntTuple, ? super IntTuple> distanceFunction) {
        MutableIntTuple fReference = IntTuples.copy((IntTuple)reference);
        return new Comparator<IntTuple>((IntTuple)fReference){
            final /* synthetic */ IntTuple val$fReference;
            {
                this.val$fReference = intTuple;
            }

            @Override
            public int compare(IntTuple t0, IntTuple t1) {
                double d0 = distanceFunction.applyAsDouble(this.val$fReference, t0);
                double d1 = distanceFunction.applyAsDouble(this.val$fReference, t1);
                return Double.compare(d0, d1);
            }
        };
    }

    public static DistanceFunction<IntTuple> euclidean() {
        return new IntTupleDistanceFunctionEuclidean();
    }

    public static DistanceFunction<IntTuple> euclideanSquared() {
        return new IntTupleDistanceFunctionEuclideanSquared();
    }

    public static DistanceFunction<IntTuple> wrappedEuclidean(IntTuple size) {
        return new IntTupleDistanceFunctionEuclideanWrapped(size);
    }

    public static DistanceFunction<IntTuple> wrappedEuclideanSquared(IntTuple size) {
        return new IntTupleDistanceFunctionEuclideanSquaredWrapped(size);
    }

    public static DistanceFunction<IntTuple> manhattan() {
        return new IntTupleDistanceFunctionManhattan();
    }

    public static DistanceFunction<IntTuple> wrappedManhattan(IntTuple size) {
        return new IntTupleDistanceFunctionManhattanWrapped(size);
    }

    public static DistanceFunction<IntTuple> chebyshev() {
        return new IntTupleDistanceFunctionChebyshev();
    }

    public static DistanceFunction<IntTuple> wrappedChebyshev(IntTuple size) {
        return new IntTupleDistanceFunctionChebyshevWrapped(size);
    }

    static double computeEuclidean(IntTuple t0, IntTuple t1) {
        return Math.sqrt(IntTupleDistanceFunctions.computeEuclideanSquared(t0, t1));
    }

    static double computeEuclideanSquared(IntTuple t0, IntTuple t1) {
        Utils.checkForEqualSize((Tuple)t0, (Tuple)t1);
        long sum = 0L;
        for (int i = 0; i < t0.getSize(); ++i) {
            int d = t0.get(i) - t1.get(i);
            sum += (long)(d * d);
        }
        return sum;
    }

    static double computeWrappedEuclidean(IntTuple t0, IntTuple t1, IntTuple size) {
        return Math.sqrt(IntTupleDistanceFunctions.computeWrappedEuclideanSquared(t0, t1, size));
    }

    static long computeWrappedEuclideanSquared(IntTuple t0, IntTuple t1, IntTuple size) {
        Utils.checkForEqualSize((Tuple)t0, (Tuple)t1);
        Utils.checkForEqualSize((Tuple)t0, (Tuple)size);
        long sum = 0L;
        for (int i = 0; i < t0.getSize(); ++i) {
            int d = MathUtils.wrappedDistance(t0.get(i), t1.get(i), size.get(i));
            sum += (long)(d * d);
        }
        return sum;
    }

    static int computeManhattan(IntTuple t0, IntTuple t1) {
        Utils.checkForEqualSize((Tuple)t0, (Tuple)t1);
        int sum = 0;
        for (int i = 0; i < t0.getSize(); ++i) {
            int d = t0.get(i) - t1.get(i);
            sum += Math.abs(d);
        }
        return sum;
    }

    static int computeWrappedManhattan(IntTuple t0, IntTuple t1, IntTuple size) {
        Utils.checkForEqualSize((Tuple)t0, (Tuple)t1);
        int sum = 0;
        for (int i = 0; i < t0.getSize(); ++i) {
            int d = MathUtils.wrappedDistance(t0.get(i), t1.get(i), size.get(i));
            sum += Math.abs(d);
        }
        return sum;
    }

    static int computeChebyshev(IntTuple t0, IntTuple t1) {
        Utils.checkForEqualSize((Tuple)t0, (Tuple)t1);
        int max = 0;
        for (int i = 0; i < t0.getSize(); ++i) {
            int d = t0.get(i) - t1.get(i);
            max = Math.max(max, Math.abs(d));
        }
        return max;
    }

    static int computeWrappedChebyshev(IntTuple t0, IntTuple t1, IntTuple size) {
        Utils.checkForEqualSize((Tuple)t0, (Tuple)t1);
        int max = 0;
        for (int i = 0; i < t0.getSize(); ++i) {
            int d = MathUtils.wrappedDistance(t0.get(i), t1.get(i), size.get(i));
            max = Math.max(max, Math.abs(d));
        }
        return max;
    }

    private IntTupleDistanceFunctions() {
    }
}

