/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.distance.tuples.j;

import de.javagl.nd.distance.DistanceFunction;
import de.javagl.nd.distance.tuples.j.LongTupleDistanceFunctionChebyshev;
import de.javagl.nd.distance.tuples.j.LongTupleDistanceFunctionChebyshevWrapped;
import de.javagl.nd.distance.tuples.j.LongTupleDistanceFunctionEuclidean;
import de.javagl.nd.distance.tuples.j.LongTupleDistanceFunctionEuclideanSquared;
import de.javagl.nd.distance.tuples.j.LongTupleDistanceFunctionEuclideanSquaredWrapped;
import de.javagl.nd.distance.tuples.j.LongTupleDistanceFunctionEuclideanWrapped;
import de.javagl.nd.distance.tuples.j.LongTupleDistanceFunctionManhattan;
import de.javagl.nd.distance.tuples.j.LongTupleDistanceFunctionManhattanWrapped;
import de.javagl.nd.distance.tuples.j.MathUtils;
import de.javagl.nd.tuples.Tuple;
import de.javagl.nd.tuples.Utils;
import de.javagl.nd.tuples.j.LongTuple;
import de.javagl.nd.tuples.j.LongTuples;
import de.javagl.nd.tuples.j.MutableLongTuple;
import java.util.Comparator;
import java.util.function.ToDoubleBiFunction;

public class LongTupleDistanceFunctions {
    public static Comparator<LongTuple> byDistanceComparator(LongTuple reference, final ToDoubleBiFunction<? super LongTuple, ? super LongTuple> distanceFunction) {
        MutableLongTuple fReference = LongTuples.copy((LongTuple)reference);
        return new Comparator<LongTuple>((LongTuple)fReference){
            final /* synthetic */ LongTuple val$fReference;
            {
                this.val$fReference = longTuple;
            }

            @Override
            public int compare(LongTuple t0, LongTuple t1) {
                double d0 = distanceFunction.applyAsDouble(this.val$fReference, t0);
                double d1 = distanceFunction.applyAsDouble(this.val$fReference, t1);
                return Double.compare(d0, d1);
            }
        };
    }

    public static DistanceFunction<LongTuple> euclidean() {
        return new LongTupleDistanceFunctionEuclidean();
    }

    public static DistanceFunction<LongTuple> euclideanSquared() {
        return new LongTupleDistanceFunctionEuclideanSquared();
    }

    public static DistanceFunction<LongTuple> wrappedEuclidean(LongTuple size) {
        return new LongTupleDistanceFunctionEuclideanWrapped(size);
    }

    public static DistanceFunction<LongTuple> wrappedEuclideanSquared(LongTuple size) {
        return new LongTupleDistanceFunctionEuclideanSquaredWrapped(size);
    }

    public static DistanceFunction<LongTuple> manhattan() {
        return new LongTupleDistanceFunctionManhattan();
    }

    public static DistanceFunction<LongTuple> wrappedManhattan(LongTuple size) {
        return new LongTupleDistanceFunctionManhattanWrapped(size);
    }

    public static DistanceFunction<LongTuple> chebyshev() {
        return new LongTupleDistanceFunctionChebyshev();
    }

    public static DistanceFunction<LongTuple> wrappedChebyshev(LongTuple size) {
        return new LongTupleDistanceFunctionChebyshevWrapped(size);
    }

    static double computeEuclidean(LongTuple t0, LongTuple t1) {
        return Math.sqrt(LongTupleDistanceFunctions.computeEuclideanSquared(t0, t1));
    }

    static double computeEuclideanSquared(LongTuple t0, LongTuple t1) {
        Utils.checkForEqualSize((Tuple)t0, (Tuple)t1);
        long sum = 0L;
        for (int i = 0; i < t0.getSize(); ++i) {
            long d = t0.get(i) - t1.get(i);
            sum += d * d;
        }
        return sum;
    }

    static double computeWrappedEuclidean(LongTuple t0, LongTuple t1, LongTuple size) {
        return Math.sqrt(LongTupleDistanceFunctions.computeWrappedEuclideanSquared(t0, t1, size));
    }

    static long computeWrappedEuclideanSquared(LongTuple t0, LongTuple t1, LongTuple size) {
        Utils.checkForEqualSize((Tuple)t0, (Tuple)t1);
        Utils.checkForEqualSize((Tuple)t0, (Tuple)size);
        long sum = 0L;
        for (int i = 0; i < t0.getSize(); ++i) {
            long d = MathUtils.wrappedDistance(t0.get(i), t1.get(i), size.get(i));
            sum += d * d;
        }
        return sum;
    }

    static long computeManhattan(LongTuple t0, LongTuple t1) {
        Utils.checkForEqualSize((Tuple)t0, (Tuple)t1);
        long sum = 0L;
        for (int i = 0; i < t0.getSize(); ++i) {
            long d = t0.get(i) - t1.get(i);
            sum += Math.abs(d);
        }
        return sum;
    }

    static long computeWrappedManhattan(LongTuple t0, LongTuple t1, LongTuple size) {
        Utils.checkForEqualSize((Tuple)t0, (Tuple)t1);
        long sum = 0L;
        for (int i = 0; i < t0.getSize(); ++i) {
            long d = MathUtils.wrappedDistance(t0.get(i), t1.get(i), size.get(i));
            sum += Math.abs(d);
        }
        return sum;
    }

    static long computeChebyshev(LongTuple t0, LongTuple t1) {
        Utils.checkForEqualSize((Tuple)t0, (Tuple)t1);
        long max = 0L;
        for (int i = 0; i < t0.getSize(); ++i) {
            long d = t0.get(i) - t1.get(i);
            max = Math.max(max, Math.abs(d));
        }
        return max;
    }

    static long computeWrappedChebyshev(LongTuple t0, LongTuple t1, LongTuple size) {
        Utils.checkForEqualSize((Tuple)t0, (Tuple)t1);
        long max = 0L;
        for (int i = 0; i < t0.getSize(); ++i) {
            long d = MathUtils.wrappedDistance(t0.get(i), t1.get(i), size.get(i));
            max = Math.max(max, Math.abs(d));
        }
        return max;
    }

    private LongTupleDistanceFunctions() {
    }
}

