/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.d;

import de.javagl.nd.tuples.Utils;
import de.javagl.nd.tuples.d.AbstractMutableDoubleTuple;
import de.javagl.nd.tuples.d.MutableDoubleTuple;
import java.nio.DoubleBuffer;
import java.util.Objects;

final class BufferDoubleTuple
extends AbstractMutableDoubleTuple {
    private final DoubleBuffer buffer;

    BufferDoubleTuple(DoubleBuffer buffer) {
        Objects.requireNonNull(buffer, "The buffer is null");
        this.buffer = buffer;
    }

    @Override
    public int getSize() {
        return this.buffer.capacity();
    }

    @Override
    public double get(int index) {
        return this.buffer.get(index);
    }

    @Override
    public void set(int index, double value) {
        this.buffer.put(index, value);
    }

    @Override
    public MutableDoubleTuple subTuple(int fromIndex, int toIndex) {
        Utils.checkForValidSubTupleIndices(this.getSize(), fromIndex, toIndex);
        int oldPosition = this.buffer.position();
        int oldLimit = this.buffer.limit();
        this.buffer.position(fromIndex);
        this.buffer.limit(oldPosition + (toIndex - fromIndex));
        BufferDoubleTuple result = new BufferDoubleTuple(this.buffer.slice());
        this.buffer.position(oldPosition);
        this.buffer.limit(oldLimit);
        return result;
    }
}

