/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.d;

import de.javagl.nd.tuples.d.AbstractDoubleTuple;
import de.javagl.nd.tuples.d.DoubleTuple;
import de.javagl.nd.tuples.d.DoubleTuples;

final class ConstantDoubleTuple
extends AbstractDoubleTuple
implements DoubleTuple {
    private final int size;
    private final double value;

    ConstantDoubleTuple(int size, double value) {
        if (size < 0) {
            throw new IllegalArgumentException("Size is negative: " + size);
        }
        this.size = size;
        this.value = value;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public double get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index " + index + ", size " + this.size);
        }
        return this.value;
    }

    @Override
    public DoubleTuple subTuple(int fromIndex, int toIndex) {
        return DoubleTuples.constant(toIndex - fromIndex, this.value);
    }
}

