/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.d;

import de.javagl.nd.tuples.d.AbstractMutableDoubleTuple;
import de.javagl.nd.tuples.d.DoubleTuple;
import java.util.Objects;

class DefaultDoubleTuple
extends AbstractMutableDoubleTuple {
    private final double[] data;

    DefaultDoubleTuple(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("The size is negative: " + size);
        }
        this.data = new double[size];
    }

    DefaultDoubleTuple(double ... data) {
        Objects.requireNonNull(data, "The data is null");
        this.data = data;
    }

    DefaultDoubleTuple(DoubleTuple other) {
        this.data = new double[other.getSize()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = other.get(i);
        }
    }

    @Override
    public int getSize() {
        return this.data.length;
    }

    @Override
    public double get(int index) {
        return this.data[index];
    }

    @Override
    public void set(int index, double value) {
        this.data[index] = value;
    }
}

