/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.d;

import de.javagl.nd.tuples.Tuple;
import de.javagl.nd.tuples.d.DoubleTuple;
import de.javagl.nd.tuples.d.DoubleTuples;
import de.javagl.nd.tuples.d.MutableDoubleTuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DoubleTupleCollections {
    public static void create(int dimensions, int numElements, Collection<? super MutableDoubleTuple> target) {
        for (int i = 0; i < numElements; ++i) {
            target.add(DoubleTuples.create(dimensions));
        }
    }

    public static List<MutableDoubleTuple> create(int dimensions, int numElements) {
        ArrayList<MutableDoubleTuple> list = new ArrayList<MutableDoubleTuple>();
        DoubleTupleCollections.create(dimensions, numElements, list);
        return list;
    }

    public static List<MutableDoubleTuple> deepCopy(Collection<? extends DoubleTuple> tuples) {
        ArrayList<MutableDoubleTuple> result = new ArrayList<MutableDoubleTuple>(tuples.size());
        for (DoubleTuple doubleTuple : tuples) {
            if (doubleTuple == null) {
                result.add(null);
                continue;
            }
            result.add(DoubleTuples.copy(doubleTuple));
        }
        return result;
    }

    public static MutableDoubleTuple min(Collection<? extends DoubleTuple> tuples, MutableDoubleTuple result) {
        if (tuples.isEmpty()) {
            return null;
        }
        int size = DoubleTupleCollections.getSize(result, tuples);
        DoubleTuple identity = DoubleTuples.constant(size, Double.POSITIVE_INFINITY);
        MutableDoubleTuple localResult = tuples.parallelStream().collect(() -> DoubleTuples.copy(identity), (r, t) -> DoubleTuples.min(r, t, r), (r0, r1) -> DoubleTuples.min(r0, r1, r0));
        if (result == null) {
            return localResult;
        }
        result.set(localResult);
        return result;
    }

    public static MutableDoubleTuple max(Collection<? extends DoubleTuple> tuples, MutableDoubleTuple result) {
        if (tuples.isEmpty()) {
            return null;
        }
        int size = DoubleTupleCollections.getSize(result, tuples);
        DoubleTuple identity = DoubleTuples.constant(size, Double.NEGATIVE_INFINITY);
        MutableDoubleTuple localResult = tuples.parallelStream().collect(() -> DoubleTuples.copy(identity), (r, t) -> DoubleTuples.max(r, t, r), (r0, r1) -> DoubleTuples.max(r0, r1, r0));
        if (result == null) {
            return localResult;
        }
        result.set(localResult);
        return result;
    }

    public static MutableDoubleTuple add(Collection<? extends DoubleTuple> tuples, MutableDoubleTuple result) {
        if (tuples.isEmpty()) {
            return null;
        }
        int size = DoubleTupleCollections.getSize(result, tuples);
        MutableDoubleTuple localResult = tuples.parallelStream().collect(() -> DoubleTuples.create(size), (r, t) -> DoubleTuples.add((DoubleTuple)r, t, r), (r0, r1) -> DoubleTuples.add((DoubleTuple)r0, r1, r0));
        if (result == null) {
            return localResult;
        }
        result.set(localResult);
        return result;
    }

    private static int getSize(Tuple t, Iterable<? extends Tuple> tuples) {
        Tuple first;
        if (t != null) {
            return t.getSize();
        }
        Iterator<? extends Tuple> iterator = tuples.iterator();
        if (iterator.hasNext() && (first = iterator.next()) != null) {
            return first.getSize();
        }
        return -1;
    }

    public static List<MutableDoubleTuple> standardize(Collection<? extends DoubleTuple> inputs, List<MutableDoubleTuple> results) {
        results = DoubleTupleCollections.validate(inputs, results);
        MutableDoubleTuple mean = DoubleTupleCollections.arithmeticMean(inputs, null);
        MutableDoubleTuple standardDeviation = DoubleTupleCollections.standardDeviationFromMean(inputs, mean, null);
        int index = 0;
        for (DoubleTuple doubleTuple : inputs) {
            MutableDoubleTuple result = results.get(index);
            DoubleTuples.subtract(doubleTuple, mean, result);
            DoubleTuples.divide(result, standardDeviation, result);
            ++index;
        }
        boolean printResults = false;
        if (printResults) {
            MutableDoubleTuple mutableDoubleTuple = DoubleTupleCollections.arithmeticMean(results, null);
            MutableDoubleTuple newStandardDeviation = DoubleTupleCollections.standardDeviationFromMean(results, mutableDoubleTuple, null);
            MutableDoubleTuple min = DoubleTupleCollections.min(results, null);
            MutableDoubleTuple max = DoubleTupleCollections.max(results, null);
            System.out.println("After standardization:");
            System.out.println("mean              : " + mutableDoubleTuple);
            System.out.println("standard deviation: " + newStandardDeviation);
            System.out.println("min               : " + min);
            System.out.println("max               : " + max);
        }
        return results;
    }

    private static List<MutableDoubleTuple> validate(Collection<? extends DoubleTuple> inputs, List<MutableDoubleTuple> results) {
        if (results == null) {
            results = new ArrayList<MutableDoubleTuple>(inputs.size());
            for (DoubleTuple doubleTuple : inputs) {
                results.add(DoubleTuples.create(doubleTuple.getSize()));
            }
        } else if (inputs.size() != results.size()) {
            throw new IllegalArgumentException("The number of inputs (" + inputs.size() + ") must " + "be the same as the number of results " + "(" + results.size() + ")");
        }
        return results;
    }

    public static List<MutableDoubleTuple> normalize(Collection<? extends DoubleTuple> inputs, List<MutableDoubleTuple> results) {
        results = DoubleTupleCollections.validate(inputs, results);
        int index = 0;
        for (DoubleTuple doubleTuple : inputs) {
            MutableDoubleTuple result = results.get(index);
            DoubleTuples.normalize(doubleTuple, result);
            ++index;
        }
        return results;
    }

    public static MutableDoubleTuple arithmeticMean(Collection<? extends DoubleTuple> tuples, MutableDoubleTuple result) {
        if (tuples.isEmpty()) {
            return null;
        }
        result = DoubleTupleCollections.add(tuples, result);
        return DoubleTuples.multiply((DoubleTuple)result, 1.0 / (double)tuples.size(), result);
    }

    public static MutableDoubleTuple variance(Collection<? extends DoubleTuple> tuples, MutableDoubleTuple result) {
        if (tuples.isEmpty()) {
            return null;
        }
        MutableDoubleTuple mean = DoubleTupleCollections.arithmeticMean(tuples, null);
        return DoubleTupleCollections.variance(tuples, mean, result);
    }

    public static MutableDoubleTuple variance(Collection<? extends DoubleTuple> tuples, DoubleTuple mean, MutableDoubleTuple result) {
        if (tuples.isEmpty()) {
            return null;
        }
        DoubleTuple first = tuples.iterator().next();
        result = DoubleTuples.validate(first, result);
        DoubleTuples.set(result, 0.0);
        int d = result.getSize();
        for (DoubleTuple doubleTuple : tuples) {
            for (int i = 0; i < d; ++i) {
                double difference = doubleTuple.get(i) - mean.get(i);
                double v = result.get(i);
                result.set(i, v + difference * difference);
            }
        }
        return DoubleTuples.multiply((DoubleTuple)result, 1.0 / (double)tuples.size(), result);
    }

    public static MutableDoubleTuple standardDeviation(Collection<? extends DoubleTuple> tuples, MutableDoubleTuple result) {
        if (tuples.isEmpty()) {
            return null;
        }
        MutableDoubleTuple mean = DoubleTupleCollections.arithmeticMean(tuples, null);
        return DoubleTupleCollections.standardDeviationFromMean(tuples, mean, result);
    }

    public static MutableDoubleTuple standardDeviationFromMean(Collection<? extends DoubleTuple> tuples, DoubleTuple mean, MutableDoubleTuple result) {
        if (tuples.isEmpty()) {
            return null;
        }
        result = DoubleTupleCollections.variance(tuples, mean, result);
        return DoubleTuples.standardDeviationFromVariance(result, result);
    }

    private DoubleTupleCollections() {
    }
}

