/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.d;

import de.javagl.nd.tuples.Utils;
import de.javagl.nd.tuples.d.DoubleTuple;
import de.javagl.nd.tuples.d.DoubleTuples;
import de.javagl.nd.tuples.d.MutableDoubleTuple;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;

public class DoubleTupleFunctions {
    public static MutableDoubleTuple apply(DoubleTuple t0, DoubleTuple t1, DoubleBinaryOperator op, MutableDoubleTuple result) {
        Utils.checkForEqualSize(t0, t1);
        result = DoubleTuples.validate(t0, result);
        int n = t0.getSize();
        for (int i = 0; i < n; ++i) {
            double operand0 = t0.get(i);
            double operand1 = t1.get(i);
            double r = op.applyAsDouble(operand0, operand1);
            result.set(i, r);
        }
        return result;
    }

    public static MutableDoubleTuple apply(DoubleTuple t0, DoubleUnaryOperator op, MutableDoubleTuple result) {
        result = DoubleTuples.validate(t0, result);
        int n = t0.getSize();
        for (int i = 0; i < n; ++i) {
            double operand0 = t0.get(i);
            double r = op.applyAsDouble(operand0);
            result.set(i, r);
        }
        return result;
    }

    public static double reduce(DoubleTuple t0, double identity, DoubleBinaryOperator op) {
        double result = identity;
        int n = t0.getSize();
        for (int i = 0; i < n; ++i) {
            double operand0 = t0.get(i);
            result = op.applyAsDouble(result, operand0);
        }
        return result;
    }

    public static MutableDoubleTuple inclusiveScan(DoubleTuple t0, DoubleBinaryOperator op, MutableDoubleTuple result) {
        result = DoubleTuples.validate(t0, result);
        int n = t0.getSize();
        if (n > 0) {
            result.set(0, t0.get(0));
            for (int i = 1; i < n; ++i) {
                double operand0 = result.get(i - 1);
                double operand1 = t0.get(i);
                double r = op.applyAsDouble(operand0, operand1);
                result.set(i, r);
            }
        }
        return result;
    }

    public static MutableDoubleTuple exclusiveScan(DoubleTuple t0, double identity, DoubleBinaryOperator op, MutableDoubleTuple result) {
        result = DoubleTuples.validate(t0, result);
        int n = t0.getSize();
        if (n > 0) {
            double previousElement = t0.get(0);
            result.set(0, identity);
            for (int i = 1; i < n; ++i) {
                double operand0 = result.get(i - 1);
                double operand1 = previousElement;
                double r = op.applyAsDouble(operand0, operand1);
                previousElement = t0.get(i);
                result.set(i, r);
            }
        }
        return result;
    }

    private DoubleTupleFunctions() {
    }
}

