/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.d;

import de.javagl.nd.tuples.d.DoubleTuple;
import java.util.Comparator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.DoubleConsumer;

class DoubleTupleSpliterator
implements Spliterator.OfDouble {
    private final DoubleTuple tuple;
    private int index;
    private final int end;
    private final int characteristics;

    public DoubleTupleSpliterator(DoubleTuple tuple, int index, int end) {
        this.tuple = tuple;
        this.index = index;
        this.end = end;
        this.characteristics = 17488;
    }

    @Override
    public Spliterator.OfDouble trySplit() {
        int center = this.index + this.end >> 1;
        if (this.index >= center) {
            return null;
        }
        DoubleTupleSpliterator result = new DoubleTupleSpliterator(this.tuple, this.index, center);
        this.index = center;
        return result;
    }

    @Override
    public void forEachRemaining(DoubleConsumer action) {
        Objects.requireNonNull(action, "The action is null");
        if (this.index >= 0 && this.end <= this.tuple.getSize()) {
            while (this.index < this.end) {
                action.accept(this.tuple.get(this.index++));
            }
        }
    }

    @Override
    public boolean tryAdvance(DoubleConsumer action) {
        Objects.requireNonNull(action, "The action is null");
        if (this.index >= 0 && this.index < this.end) {
            action.accept(this.tuple.get(this.index++));
            return true;
        }
        return false;
    }

    @Override
    public long estimateSize() {
        return this.end - this.index;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    @Override
    public Comparator<? super Double> getComparator() {
        return null;
    }
}

