/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.d;

import de.javagl.nd.tuples.Order;
import de.javagl.nd.tuples.Utils;
import de.javagl.nd.tuples.d.AbstractDoubleTuple;
import de.javagl.nd.tuples.d.AbstractMutableDoubleTuple;
import de.javagl.nd.tuples.d.ArrayDoubleTuple;
import de.javagl.nd.tuples.d.BufferDoubleTuple;
import de.javagl.nd.tuples.d.ConstantDoubleTuple;
import de.javagl.nd.tuples.d.DefaultDoubleTuple;
import de.javagl.nd.tuples.d.DoubleTuple;
import de.javagl.nd.tuples.d.DoubleTupleFunctions;
import de.javagl.nd.tuples.d.MutableDoubleTuple;
import de.javagl.nd.tuples.d.MutableSubDoubleTuple;
import de.javagl.nd.tuples.d.SubDoubleTuple;
import java.nio.DoubleBuffer;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;

public class DoubleTuples {
    private static final int ZERO_POOL_SIZE = 5;
    private static final DoubleTuple[] ZEROS = new DoubleTuple[5];

    private static DoubleTuple createZero(int size) {
        return DoubleTuples.constant(size, 0.0);
    }

    public static DoubleTuple zero(int size) {
        if (size >= 0 && size < 5) {
            return ZEROS[size];
        }
        return DoubleTuples.createZero(size);
    }

    public static DoubleTuple constant(int size, double value) {
        return new ConstantDoubleTuple(size, value);
    }

    public static MutableDoubleTuple create(int size) {
        return new DefaultDoubleTuple(size);
    }

    public static MutableDoubleTuple copy(DoubleTuple other) {
        return new DefaultDoubleTuple(other);
    }

    public static MutableDoubleTuple of(double ... values) {
        return new DefaultDoubleTuple((double[])values.clone());
    }

    public static MutableDoubleTuple wrap(double ... values) {
        return new DefaultDoubleTuple(values);
    }

    public static MutableDoubleTuple wrap(DoubleBuffer buffer) {
        return new BufferDoubleTuple(buffer);
    }

    public static MutableDoubleTuple wrap(double[] data, int offset, int size) {
        return new ArrayDoubleTuple(data, offset, size);
    }

    static DoubleTuple createSubTuple(DoubleTuple parent, int fromIndex, int toIndex) {
        return new SubDoubleTuple(parent, fromIndex, toIndex);
    }

    static MutableDoubleTuple createSubTuple(MutableDoubleTuple parent, int fromIndex, int toIndex) {
        return new MutableSubDoubleTuple(parent, fromIndex, toIndex);
    }

    public static double[] toArray(DoubleTuple t) {
        int d = t.getSize();
        double[] result = new double[d];
        for (int i = 0; i < d; ++i) {
            result[i] = t.get(i);
        }
        return result;
    }

    public static List<Double> asList(final DoubleTuple t) {
        if (t == null) {
            throw new NullPointerException("The tuple may not be null");
        }
        return new AbstractList<Double>(){

            @Override
            public Double get(int index) {
                return t.get(index);
            }

            @Override
            public int size() {
                return t.getSize();
            }
        };
    }

    public static List<Double> asList(final MutableDoubleTuple t) {
        if (t == null) {
            throw new NullPointerException("The tuple may not be null");
        }
        return new AbstractList<Double>(){

            @Override
            public Double get(int index) {
                return t.get(index);
            }

            @Override
            public int size() {
                return t.getSize();
            }

            @Override
            public Double set(int index, Double element) {
                double oldValue = t.get(index);
                t.set(index, element);
                return oldValue;
            }
        };
    }

    public static void set(MutableDoubleTuple t, double v) {
        for (int i = 0; i < t.getSize(); ++i) {
            t.set(i, v);
        }
    }

    public static MutableDoubleTuple reverse(DoubleTuple t, MutableDoubleTuple result) {
        if (t == (result = DoubleTuples.validate(t, result))) {
            int n = t.getSize();
            int nh = n / 2;
            for (int i = 0; i < nh; ++i) {
                double temp = result.get(i);
                result.set(i, result.get(n - 1 - i));
                result.set(n - 1 - i, temp);
            }
        } else {
            int n = t.getSize();
            for (int i = 0; i < n; ++i) {
                result.set(i, t.get(n - 1 - i));
            }
        }
        return result;
    }

    public static DoubleTuple reversed(final DoubleTuple t) {
        Objects.requireNonNull(t, "The input tuple is null");
        return new AbstractDoubleTuple(){

            @Override
            public int getSize() {
                return t.getSize();
            }

            @Override
            public double get(int index) {
                return t.get(t.getSize() - 1 - index);
            }
        };
    }

    public static MutableDoubleTuple reversed(final MutableDoubleTuple t) {
        Objects.requireNonNull(t, "The input tuple is null");
        return new AbstractMutableDoubleTuple(){

            @Override
            public int getSize() {
                return t.getSize();
            }

            @Override
            public double get(int index) {
                return t.get(t.getSize() - 1 - index);
            }

            @Override
            public void set(int index, double value) {
                t.set(t.getSize() - 1 - index, value);
            }
        };
    }

    public static MutableDoubleTuple clamp(DoubleTuple t, double min, double max, MutableDoubleTuple result) {
        result = DoubleTuples.validate(t, result);
        for (int i = 0; i < result.getSize(); ++i) {
            double v = t.get(i);
            double r = Math.min(max, Math.max(min, v));
            result.set(i, r);
        }
        return result;
    }

    public static MutableDoubleTuple clamp(DoubleTuple t, DoubleTuple min, DoubleTuple max, MutableDoubleTuple result) {
        Utils.checkForEqualSize(min, max);
        result = DoubleTuples.validate(t, result);
        for (int i = 0; i < result.getSize(); ++i) {
            double v = t.get(i);
            double minV = min.get(i);
            double maxV = max.get(i);
            double r = Math.min(maxV, Math.max(minV, v));
            result.set(i, r);
        }
        return result;
    }

    public static MutableDoubleTuple negate(DoubleTuple t0, MutableDoubleTuple result) {
        return DoubleTupleFunctions.apply(t0, a -> -a, result);
    }

    public static MutableDoubleTuple add(DoubleTuple t0, DoubleTuple t1, MutableDoubleTuple result) {
        return DoubleTupleFunctions.apply(t0, t1, (a, b) -> a + b, result);
    }

    public static MutableDoubleTuple subtract(DoubleTuple t0, DoubleTuple t1, MutableDoubleTuple result) {
        return DoubleTupleFunctions.apply(t0, t1, (a, b) -> a - b, result);
    }

    public static MutableDoubleTuple multiply(DoubleTuple t0, DoubleTuple t1, MutableDoubleTuple result) {
        return DoubleTupleFunctions.apply(t0, t1, (a, b) -> a * b, result);
    }

    public static MutableDoubleTuple divide(DoubleTuple t0, DoubleTuple t1, MutableDoubleTuple result) {
        return DoubleTupleFunctions.apply(t0, t1, (a, b) -> a / b, result);
    }

    public static MutableDoubleTuple add(DoubleTuple t0, double value, MutableDoubleTuple result) {
        return DoubleTupleFunctions.apply(t0, a -> a + value, result);
    }

    public static MutableDoubleTuple subtract(DoubleTuple t0, double value, MutableDoubleTuple result) {
        return DoubleTupleFunctions.apply(t0, a -> a - value, result);
    }

    public static MutableDoubleTuple multiply(DoubleTuple t0, double factor, MutableDoubleTuple result) {
        return DoubleTupleFunctions.apply(t0, a -> a * factor, result);
    }

    public static MutableDoubleTuple addScaled(DoubleTuple t0, double factor, DoubleTuple t1, MutableDoubleTuple result) {
        return DoubleTupleFunctions.apply(t0, t1, (a, b) -> a + factor * b, result);
    }

    public static double dot(DoubleTuple t0, DoubleTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        double result = 0.0;
        for (int i = 0; i < t0.getSize(); ++i) {
            result += t0.get(i) * t1.get(i);
        }
        return result;
    }

    public static double min(DoubleTuple t) {
        return DoubleTupleFunctions.reduce(t, Double.POSITIVE_INFINITY, Math::min);
    }

    public static double max(DoubleTuple t) {
        return DoubleTupleFunctions.reduce(t, Double.NEGATIVE_INFINITY, Math::max);
    }

    public static MutableDoubleTuple min(DoubleTuple t0, DoubleTuple t1, MutableDoubleTuple result) {
        return DoubleTupleFunctions.apply(t0, t1, Math::min, result);
    }

    public static MutableDoubleTuple max(DoubleTuple t0, DoubleTuple t1, MutableDoubleTuple result) {
        return DoubleTupleFunctions.apply(t0, t1, Math::max, result);
    }

    public static int compareLexicographically(DoubleTuple t0, DoubleTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        for (int i = 0; i < t0.getSize(); ++i) {
            if (t0.get(i) < t1.get(i)) {
                return -1;
            }
            if (!(t0.get(i) > t1.get(i))) continue;
            return 1;
        }
        return 0;
    }

    public static int compareColexicographically(DoubleTuple t0, DoubleTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        for (int i = t0.getSize() - 1; i >= 0; --i) {
            if (t0.get(i) < t1.get(i)) {
                return -1;
            }
            if (!(t0.get(i) > t1.get(i))) continue;
            return 1;
        }
        return 0;
    }

    public static Comparator<DoubleTuple> comparator(Order order) {
        if (order == Order.LEXICOGRAPHICAL) {
            return (t0, t1) -> DoubleTuples.compareLexicographically(t0, t1);
        }
        if (order == Order.COLEXICOGRAPHICAL) {
            return (t0, t1) -> DoubleTuples.compareColexicographically(t0, t1);
        }
        return null;
    }

    public static boolean areElementsGreaterThan(DoubleTuple t0, DoubleTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        for (int i = 0; i < t0.getSize(); ++i) {
            if (!(t0.get(i) <= t1.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsGreaterThanOrEqual(DoubleTuple t0, DoubleTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        for (int i = 0; i < t0.getSize(); ++i) {
            if (!(t0.get(i) < t1.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsLessThan(DoubleTuple t0, DoubleTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        for (int i = 0; i < t0.getSize(); ++i) {
            if (!(t0.get(i) >= t1.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsLessThanOrEqual(DoubleTuple t0, DoubleTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        for (int i = 0; i < t0.getSize(); ++i) {
            if (!(t0.get(i) > t1.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsGreaterThan(DoubleTuple t, double value) {
        for (int i = 0; i < t.getSize(); ++i) {
            if (!(t.get(i) <= value)) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsGreaterThanOrEqual(DoubleTuple t, double value) {
        for (int i = 0; i < t.getSize(); ++i) {
            if (!(t.get(i) < value)) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsLessThan(DoubleTuple t, double value) {
        for (int i = 0; i < t.getSize(); ++i) {
            if (!(t.get(i) >= value)) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsLessThanOrEqual(DoubleTuple t, double value) {
        for (int i = 0; i < t.getSize(); ++i) {
            if (!(t.get(i) > value)) continue;
            return false;
        }
        return true;
    }

    static MutableDoubleTuple validate(DoubleTuple t, MutableDoubleTuple result) {
        if (result == null) {
            result = DoubleTuples.create(t.getSize());
        } else {
            Utils.checkForEqualSize(t, result);
        }
        return result;
    }

    static String toString(DoubleTuple tuple) {
        if (tuple == null) {
            return "null";
        }
        return DoubleTuples.toString(tuple, tuple.getSize(), tuple.getSize());
    }

    static String toString(DoubleTuple tuple, Locale locale, String format) {
        if (tuple == null) {
            return "null";
        }
        return DoubleTuples.toString(tuple, locale, format, tuple.getSize(), tuple.getSize());
    }

    public static String toString(DoubleTuple tuple, int maxNumLeadingElements, int maxNumTrailingElements) {
        return DoubleTuples.toString(tuple, null, null, maxNumLeadingElements, maxNumTrailingElements);
    }

    public static String toString(DoubleTuple tuple, Locale locale, String format, int maxNumLeadingElements, int maxNumTrailingElements) {
        if (tuple == null) {
            return "null";
        }
        maxNumLeadingElements = Math.max(0, maxNumLeadingElements);
        maxNumTrailingElements = Math.max(0, maxNumTrailingElements);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int n = tuple.getSize();
        if (n <= maxNumLeadingElements + maxNumTrailingElements) {
            DoubleTuples.appendRange(sb, tuple, locale, format, 0, n);
        } else {
            DoubleTuples.appendRange(sb, tuple, locale, format, 0, maxNumLeadingElements);
            if (maxNumLeadingElements > 0) {
                sb.append(", ");
            }
            sb.append("...");
            if (maxNumTrailingElements > 0) {
                sb.append(", ");
            }
            DoubleTuples.appendRange(sb, tuple, locale, format, n - maxNumTrailingElements, n);
        }
        sb.append(")");
        return sb.toString();
    }

    private static void appendRange(StringBuilder sb, DoubleTuple tuple, Locale locale, String format, int min, int max) {
        for (int i = min; i < max; ++i) {
            if (i > min) {
                sb.append(", ");
            }
            if (locale != null && format != null) {
                sb.append(String.format(locale, format, tuple.get(i)));
                continue;
            }
            sb.append(String.valueOf(tuple.get(i)));
        }
    }

    static int hashCode(DoubleTuple tuple) {
        if (tuple == null) {
            return 0;
        }
        int result = 0;
        for (int i = 0; i < tuple.getSize(); ++i) {
            double value = tuple.get(i);
            result += Double.hashCode(value);
        }
        return result;
    }

    static boolean equals(DoubleTuple tuple, Object object) {
        if (tuple == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DoubleTuple)) {
            return false;
        }
        DoubleTuple other = (DoubleTuple)object;
        if (other.getSize() != tuple.getSize()) {
            return false;
        }
        for (int i = 0; i < tuple.getSize(); ++i) {
            if (tuple.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    static boolean epsilonEquals(DoubleTuple t0, DoubleTuple t1, double epsilon) {
        int n1;
        if (t0 == t1) {
            return true;
        }
        int n0 = t0.getSize();
        if (n0 != (n1 = t1.getSize())) {
            return false;
        }
        for (int i = 0; i < n0; ++i) {
            double v1;
            double v0 = t0.get(i);
            if (!(Math.abs(v0 - (v1 = t1.get(i))) > epsilon)) continue;
            return false;
        }
        return true;
    }

    public static void randomize(MutableDoubleTuple t, double min, double max, Random random) {
        double delta = max - min;
        for (int i = 0; i < t.getSize(); ++i) {
            t.set(i, min + random.nextDouble() * delta);
        }
    }

    public static void randomize(MutableDoubleTuple t, Random random) {
        DoubleTuples.randomize(t, 0.0, 1.0, random);
    }

    public static MutableDoubleTuple createRandom(int size, Random random) {
        MutableDoubleTuple t = DoubleTuples.create(size);
        DoubleTuples.randomize(t, random);
        return t;
    }

    public static MutableDoubleTuple createRandom(int size, double min, double max, Random random) {
        MutableDoubleTuple t = DoubleTuples.create(size);
        DoubleTuples.randomize(t, min, max, random);
        return t;
    }

    public static void randomizeGaussian(MutableDoubleTuple t, Random random) {
        for (int i = 0; i < t.getSize(); ++i) {
            double value = random.nextGaussian();
            t.set(i, value);
        }
    }

    public static MutableDoubleTuple createRandomGaussian(int size, Random random) {
        MutableDoubleTuple t = DoubleTuples.create(size);
        DoubleTuples.randomizeGaussian(t, random);
        return t;
    }

    public static MutableDoubleTuple normalize(DoubleTuple t, MutableDoubleTuple result) {
        result = DoubleTuples.validate(t, result);
        double inv = 1.0 / DoubleTuples.computeL2(t);
        return DoubleTupleFunctions.apply(t, a -> a * inv, result);
    }

    public static double computeL2(DoubleTuple t) {
        double sum = 0.0;
        for (int i = 0; i < t.getSize(); ++i) {
            double ti = t.get(i);
            sum += ti * ti;
        }
        return Math.sqrt(sum);
    }

    public static MutableDoubleTuple normalizeElements(DoubleTuple t, double min, double max, MutableDoubleTuple result) {
        double range = max - min;
        double actualMin = DoubleTuples.min(t);
        double actualMax = DoubleTuples.max(t);
        double invDelta = 1.0 / (actualMax - actualMin);
        double scaling = invDelta * range;
        return DoubleTupleFunctions.apply(t, a -> min + (a - actualMin) * scaling, result);
    }

    public static MutableDoubleTuple normalizeElements(DoubleTuple t, DoubleTuple min, DoubleTuple max, MutableDoubleTuple result) {
        result = DoubleTuples.validate(t, result);
        for (int i = 0; i < result.getSize(); ++i) {
            double alpha;
            double value = t.get(i);
            double minValue = min.get(i);
            double maxValue = max.get(i);
            double newValue = alpha = (value - minValue) / (maxValue - minValue);
            result.set(i, newValue);
        }
        return result;
    }

    public static MutableDoubleTuple rescaleElements(DoubleTuple t, double oldMin, double oldMax, double newMin, double newMax, MutableDoubleTuple result) {
        double invDelta = 1.0 / (oldMax - oldMin);
        double newRange = newMax - newMin;
        double scaling = invDelta * newRange;
        return DoubleTupleFunctions.apply(t, a -> newMin + (a - oldMin) * scaling, result);
    }

    public static MutableDoubleTuple interpolate(DoubleTuple t0, DoubleTuple t1, double alpha, MutableDoubleTuple result) {
        return DoubleTupleFunctions.apply(t0, t1, (a, b) -> a + alpha * (b - a), result);
    }

    public static MutableDoubleTuple standardDeviationFromVariance(DoubleTuple variance, MutableDoubleTuple result) {
        return DoubleTupleFunctions.apply(variance, Math::sqrt, result);
    }

    public static MutableDoubleTuple standardize(DoubleTuple t, MutableDoubleTuple result) {
        result = DoubleTuples.validate(t, result);
        double mean = DoubleTuples.arithmeticMean(t);
        double standardDeviation = DoubleTuples.standardDeviationFromMean(t, mean);
        double invStandardDeviation = 1.0 / standardDeviation;
        return DoubleTupleFunctions.apply(t, a -> (a - mean) * invStandardDeviation, result);
    }

    public static double arithmeticMean(DoubleTuple t) {
        double sum = DoubleTupleFunctions.reduce(t, 0.0, (a, b) -> a + b);
        return sum / (double)t.getSize();
    }

    public static double variance(DoubleTuple t) {
        double mean = DoubleTuples.arithmeticMean(t);
        return DoubleTuples.variance(t, mean);
    }

    public static double variance(DoubleTuple t, double mean) {
        int d = t.getSize();
        double variance = 0.0;
        for (int i = 0; i < d; ++i) {
            double difference = t.get(i) - mean;
            variance += difference * difference;
        }
        return variance / (double)d;
    }

    public static double standardDeviation(DoubleTuple t) {
        double mean = DoubleTuples.arithmeticMean(t);
        return DoubleTuples.standardDeviationFromMean(t, mean);
    }

    public static double standardDeviationFromMean(DoubleTuple t, double mean) {
        double variance = DoubleTuples.variance(t, mean);
        return Math.sqrt(variance);
    }

    public static boolean containsNaN(DoubleTuple tuple) {
        for (int i = 0; i < tuple.getSize(); ++i) {
            if (!Double.isNaN(tuple.get(i))) continue;
            return true;
        }
        return false;
    }

    private DoubleTuples() {
    }

    static {
        for (int i = 0; i < 5; ++i) {
            DoubleTuples.ZEROS[i] = DoubleTuples.createZero(i);
        }
    }
}

