/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.d;

import de.javagl.nd.tuples.Utils;
import de.javagl.nd.tuples.d.AbstractMutableDoubleTuple;
import de.javagl.nd.tuples.d.DoubleTuples;
import de.javagl.nd.tuples.d.MutableDoubleTuple;

final class MutableSubDoubleTuple
extends AbstractMutableDoubleTuple {
    private final MutableDoubleTuple parent;
    private final int offset;
    private final int size;

    MutableSubDoubleTuple(MutableDoubleTuple parent, int fromIndex, int toIndex) {
        Utils.checkForValidSubTupleIndices(parent.getSize(), fromIndex, toIndex);
        this.parent = parent;
        this.offset = fromIndex;
        this.size = toIndex - fromIndex;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public double get(int index) {
        Utils.checkForValidIndex(index, this.size);
        return this.parent.get(index + this.offset);
    }

    @Override
    public void set(int index, double value) {
        Utils.checkForValidIndex(index, this.size);
        this.parent.set(index + this.offset, value);
    }

    @Override
    public MutableDoubleTuple subTuple(int fromIndex, int toIndex) {
        return DoubleTuples.createSubTuple(this.parent, this.offset + fromIndex, this.offset + toIndex);
    }
}

