/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.d;

import de.javagl.nd.tuples.Utils;
import de.javagl.nd.tuples.d.AbstractDoubleTuple;
import de.javagl.nd.tuples.d.DoubleTuple;
import de.javagl.nd.tuples.d.DoubleTuples;

final class SubDoubleTuple
extends AbstractDoubleTuple {
    private final DoubleTuple parent;
    private final int offset;
    private final int size;

    SubDoubleTuple(DoubleTuple parent, int fromIndex, int toIndex) {
        Utils.checkForValidSubTupleIndices(parent.getSize(), fromIndex, toIndex);
        this.parent = parent;
        this.offset = fromIndex;
        this.size = toIndex - fromIndex;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public double get(int index) {
        Utils.checkForValidIndex(index, this.size);
        return this.parent.get(index + this.offset);
    }

    @Override
    public DoubleTuple subTuple(int fromIndex, int toIndex) {
        return DoubleTuples.createSubTuple(this.parent, this.offset + fromIndex, this.offset + toIndex);
    }
}

