/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.i;

import de.javagl.nd.tuples.Utils;
import de.javagl.nd.tuples.i.AbstractMutableIntTuple;
import de.javagl.nd.tuples.i.MutableIntTuple;
import java.util.Arrays;
import java.util.stream.IntStream;

final class ArrayIntTuple
extends AbstractMutableIntTuple {
    private final int[] data;
    private final int offset;
    private final int size;

    ArrayIntTuple(int[] data, int offset, int size) {
        if (offset < 0) {
            throw new IllegalArgumentException("The offset is negative: " + offset);
        }
        if (size < 0) {
            throw new IllegalArgumentException("The size is negative: " + size);
        }
        if (offset + size > data.length) {
            throw new IllegalArgumentException("The offset is " + offset + " and size is " + size + ". " + "The array length must be at least " + (offset + size) + ", but only is " + data.length);
        }
        this.data = data;
        this.offset = offset;
        this.size = size;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int get(int index) {
        Utils.checkForValidIndex(index, this.size);
        return this.data[index + this.offset];
    }

    @Override
    public void set(int index, int value) {
        Utils.checkForValidIndex(index, this.size);
        this.data[index + this.offset] = value;
    }

    @Override
    public MutableIntTuple subTuple(int fromIndex, int toIndex) {
        return new ArrayIntTuple(this.data, this.offset + fromIndex, toIndex - fromIndex);
    }

    @Override
    public IntStream stream() {
        return Arrays.stream(this.data);
    }
}

