/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.i;

import de.javagl.nd.tuples.Utils;
import de.javagl.nd.tuples.i.AbstractMutableIntTuple;
import de.javagl.nd.tuples.i.MutableIntTuple;
import java.nio.IntBuffer;
import java.util.Objects;

final class BufferIntTuple
extends AbstractMutableIntTuple {
    private final IntBuffer buffer;

    BufferIntTuple(IntBuffer buffer) {
        Objects.requireNonNull(buffer, "The buffer is null");
        this.buffer = buffer;
    }

    @Override
    public int getSize() {
        return this.buffer.capacity();
    }

    @Override
    public int get(int index) {
        return this.buffer.get(index);
    }

    @Override
    public void set(int index, int value) {
        this.buffer.put(index, value);
    }

    @Override
    public MutableIntTuple subTuple(int fromIndex, int toIndex) {
        Utils.checkForValidSubTupleIndices(this.getSize(), fromIndex, toIndex);
        int oldPosition = this.buffer.position();
        int oldLimit = this.buffer.limit();
        this.buffer.position(fromIndex);
        this.buffer.limit(oldPosition + (toIndex - fromIndex));
        BufferIntTuple result = new BufferIntTuple(this.buffer.slice());
        this.buffer.position(oldPosition);
        this.buffer.limit(oldLimit);
        return result;
    }
}

