/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.i;

import de.javagl.nd.tuples.i.AbstractIntTuple;
import de.javagl.nd.tuples.i.IntTuple;
import de.javagl.nd.tuples.i.IntTuples;

final class ConstantIntTuple
extends AbstractIntTuple
implements IntTuple {
    private final int size;
    private final int value;

    ConstantIntTuple(int size, int value) {
        if (size < 0) {
            throw new IllegalArgumentException("Size is negative: " + size);
        }
        this.size = size;
        this.value = value;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index " + index + ", size " + this.size);
        }
        return this.value;
    }

    @Override
    public IntTuple subTuple(int fromIndex, int toIndex) {
        return IntTuples.constant(toIndex - fromIndex, this.value);
    }
}

