/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.i;

import de.javagl.nd.tuples.i.AbstractMutableIntTuple;
import de.javagl.nd.tuples.i.IntTuple;
import java.util.Objects;

class DefaultIntTuple
extends AbstractMutableIntTuple {
    private final int[] data;

    DefaultIntTuple(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("The size is negative: " + size);
        }
        this.data = new int[size];
    }

    DefaultIntTuple(int ... data) {
        Objects.requireNonNull(data, "The data is null");
        this.data = data;
    }

    DefaultIntTuple(IntTuple other) {
        this.data = new int[other.getSize()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = other.get(i);
        }
    }

    @Override
    public int getSize() {
        return this.data.length;
    }

    @Override
    public int get(int index) {
        return this.data[index];
    }

    @Override
    public void set(int index, int value) {
        this.data[index] = value;
    }
}

