/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.i;

import de.javagl.nd.tuples.Tuple;
import de.javagl.nd.tuples.i.IntTuple;
import de.javagl.nd.tuples.i.IntTuples;
import de.javagl.nd.tuples.i.MutableIntTuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class IntTupleCollections {
    public static void create(int dimensions, int numElements, Collection<? super MutableIntTuple> target) {
        for (int i = 0; i < numElements; ++i) {
            target.add(IntTuples.create(dimensions));
        }
    }

    public static List<MutableIntTuple> create(int dimensions, int numElements) {
        ArrayList<MutableIntTuple> list = new ArrayList<MutableIntTuple>();
        IntTupleCollections.create(dimensions, numElements, list);
        return list;
    }

    public static List<MutableIntTuple> deepCopy(Collection<? extends IntTuple> tuples) {
        ArrayList<MutableIntTuple> result = new ArrayList<MutableIntTuple>(tuples.size());
        for (IntTuple intTuple : tuples) {
            if (intTuple == null) {
                result.add(null);
                continue;
            }
            result.add(IntTuples.copy(intTuple));
        }
        return result;
    }

    public static MutableIntTuple min(Collection<? extends IntTuple> tuples, MutableIntTuple result) {
        if (tuples.isEmpty()) {
            return null;
        }
        int size = IntTupleCollections.getSize(result, tuples);
        IntTuple identity = IntTuples.constant(size, Integer.MAX_VALUE);
        MutableIntTuple localResult = tuples.parallelStream().collect(() -> IntTuples.copy(identity), (r, t) -> IntTuples.min(r, t, r), (r0, r1) -> IntTuples.min(r0, r1, r0));
        if (result == null) {
            return localResult;
        }
        result.set(localResult);
        return result;
    }

    public static MutableIntTuple max(Collection<? extends IntTuple> tuples, MutableIntTuple result) {
        if (tuples.isEmpty()) {
            return null;
        }
        int size = IntTupleCollections.getSize(result, tuples);
        IntTuple identity = IntTuples.constant(size, Integer.MIN_VALUE);
        MutableIntTuple localResult = tuples.parallelStream().collect(() -> IntTuples.copy(identity), (r, t) -> IntTuples.max(r, t, r), (r0, r1) -> IntTuples.max(r0, r1, r0));
        if (result == null) {
            return localResult;
        }
        result.set(localResult);
        return result;
    }

    public static MutableIntTuple add(Collection<? extends IntTuple> tuples, MutableIntTuple result) {
        if (tuples.isEmpty()) {
            return null;
        }
        int size = IntTupleCollections.getSize(result, tuples);
        MutableIntTuple localResult = tuples.parallelStream().collect(() -> IntTuples.create(size), (r, t) -> IntTuples.add((IntTuple)r, t, r), (r0, r1) -> IntTuples.add((IntTuple)r0, r1, r0));
        if (result == null) {
            return localResult;
        }
        result.set(localResult);
        return result;
    }

    private static int getSize(Tuple t, Iterable<? extends Tuple> tuples) {
        Tuple first;
        if (t != null) {
            return t.getSize();
        }
        Iterator<? extends Tuple> iterator = tuples.iterator();
        if (iterator.hasNext() && (first = iterator.next()) != null) {
            return first.getSize();
        }
        return -1;
    }

    private IntTupleCollections() {
    }
}

