/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.i;

import de.javagl.nd.tuples.Utils;
import de.javagl.nd.tuples.i.IntTuple;
import de.javagl.nd.tuples.i.IntTuples;
import de.javagl.nd.tuples.i.MutableIntTuple;
import java.util.function.IntBinaryOperator;
import java.util.function.IntUnaryOperator;

public class IntTupleFunctions {
    public static MutableIntTuple apply(IntTuple t0, IntTuple t1, IntBinaryOperator op, MutableIntTuple result) {
        Utils.checkForEqualSize(t0, t1);
        result = IntTuples.validate(t0, result);
        int n = t0.getSize();
        for (int i = 0; i < n; ++i) {
            int operand0 = t0.get(i);
            int operand1 = t1.get(i);
            int r = op.applyAsInt(operand0, operand1);
            result.set(i, r);
        }
        return result;
    }

    public static MutableIntTuple apply(IntTuple t0, IntUnaryOperator op, MutableIntTuple result) {
        result = IntTuples.validate(t0, result);
        int n = t0.getSize();
        for (int i = 0; i < n; ++i) {
            int operand0 = t0.get(i);
            int r = op.applyAsInt(operand0);
            result.set(i, r);
        }
        return result;
    }

    public static int reduce(IntTuple t0, int identity, IntBinaryOperator op) {
        int result = identity;
        int n = t0.getSize();
        for (int i = 0; i < n; ++i) {
            int operand0 = t0.get(i);
            result = op.applyAsInt(result, operand0);
        }
        return result;
    }

    public static MutableIntTuple inclusiveScan(IntTuple t0, IntBinaryOperator op, MutableIntTuple result) {
        result = IntTuples.validate(t0, result);
        int n = t0.getSize();
        if (n > 0) {
            result.set(0, t0.get(0));
            for (int i = 1; i < n; ++i) {
                int operand0 = result.get(i - 1);
                int operand1 = t0.get(i);
                int r = op.applyAsInt(operand0, operand1);
                result.set(i, r);
            }
        }
        return result;
    }

    public static MutableIntTuple exclusiveScan(IntTuple t0, int identity, IntBinaryOperator op, MutableIntTuple result) {
        result = IntTuples.validate(t0, result);
        int n = t0.getSize();
        if (n > 0) {
            int previousElement = t0.get(0);
            result.set(0, identity);
            for (int i = 1; i < n; ++i) {
                int operand0 = result.get(i - 1);
                int operand1 = previousElement;
                int r = op.applyAsInt(operand0, operand1);
                previousElement = t0.get(i);
                result.set(i, r);
            }
        }
        return result;
    }

    private IntTupleFunctions() {
    }
}

