/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.i;

import de.javagl.nd.tuples.Order;
import de.javagl.nd.tuples.Utils;
import de.javagl.nd.tuples.d.DoubleTuples;
import de.javagl.nd.tuples.d.MutableDoubleTuple;
import de.javagl.nd.tuples.i.AbstractIntTuple;
import de.javagl.nd.tuples.i.AbstractMutableIntTuple;
import de.javagl.nd.tuples.i.ArrayIntTuple;
import de.javagl.nd.tuples.i.BufferIntTuple;
import de.javagl.nd.tuples.i.ConstantIntTuple;
import de.javagl.nd.tuples.i.DefaultIntTuple;
import de.javagl.nd.tuples.i.IntTuple;
import de.javagl.nd.tuples.i.IntTuple2;
import de.javagl.nd.tuples.i.IntTupleFunctions;
import de.javagl.nd.tuples.i.MutableIntTuple;
import de.javagl.nd.tuples.i.MutableSubIntTuple;
import de.javagl.nd.tuples.i.SubIntTuple;
import java.nio.IntBuffer;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class IntTuples {
    private static final int ZERO_POOL_SIZE = 5;
    private static final IntTuple[] ZEROS = new IntTuple[5];

    private static IntTuple createZero(int size) {
        return IntTuples.constant(size, 0);
    }

    public static IntTuple zero(int size) {
        if (size >= 0 && size < 5) {
            return ZEROS[size];
        }
        return IntTuples.createZero(size);
    }

    public static IntTuple constant(int size, int value) {
        return new ConstantIntTuple(size, value);
    }

    public static MutableIntTuple create(int size) {
        return new DefaultIntTuple(size);
    }

    public static MutableIntTuple copy(IntTuple other) {
        return new DefaultIntTuple(other);
    }

    public static MutableIntTuple of(int ... values) {
        return new DefaultIntTuple((int[])values.clone());
    }

    public static MutableIntTuple wrap(int ... values) {
        return new DefaultIntTuple(values);
    }

    public static MutableIntTuple wrap(IntBuffer buffer) {
        return new BufferIntTuple(buffer);
    }

    public static MutableIntTuple wrap(int[] data, int offset, int size) {
        return new ArrayIntTuple(data, offset, size);
    }

    static IntTuple createSubTuple(IntTuple parent, int fromIndex, int toIndex) {
        return new SubIntTuple(parent, fromIndex, toIndex);
    }

    static MutableIntTuple createSubTuple(MutableIntTuple parent, int fromIndex, int toIndex) {
        return new MutableSubIntTuple(parent, fromIndex, toIndex);
    }

    public static int[] toArray(IntTuple t) {
        int d = t.getSize();
        int[] result = new int[d];
        for (int i = 0; i < d; ++i) {
            result[i] = t.get(i);
        }
        return result;
    }

    public static List<Integer> asList(final IntTuple t) {
        if (t == null) {
            throw new NullPointerException("The tuple may not be null");
        }
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return t.get(index);
            }

            @Override
            public int size() {
                return t.getSize();
            }
        };
    }

    public static List<Integer> asList(final MutableIntTuple t) {
        if (t == null) {
            throw new NullPointerException("The tuple may not be null");
        }
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return t.get(index);
            }

            @Override
            public int size() {
                return t.getSize();
            }

            @Override
            public Integer set(int index, Integer element) {
                int oldValue = t.get(index);
                t.set(index, element);
                return oldValue;
            }
        };
    }

    public static void set(MutableIntTuple t, int v) {
        for (int i = 0; i < t.getSize(); ++i) {
            t.set(i, v);
        }
    }

    public static MutableIntTuple reverse(IntTuple t, MutableIntTuple result) {
        if (t == (result = IntTuples.validate(t, result))) {
            int n = t.getSize();
            int nh = n / 2;
            for (int i = 0; i < nh; ++i) {
                int temp = result.get(i);
                result.set(i, result.get(n - 1 - i));
                result.set(n - 1 - i, temp);
            }
        } else {
            int n = t.getSize();
            for (int i = 0; i < n; ++i) {
                result.set(i, t.get(n - 1 - i));
            }
        }
        return result;
    }

    public static IntTuple reversed(final IntTuple t) {
        Objects.requireNonNull(t, "The input tuple is null");
        return new AbstractIntTuple(){

            @Override
            public int getSize() {
                return t.getSize();
            }

            @Override
            public int get(int index) {
                return t.get(t.getSize() - 1 - index);
            }
        };
    }

    public static MutableIntTuple reversed(final MutableIntTuple t) {
        Objects.requireNonNull(t, "The input tuple is null");
        return new AbstractMutableIntTuple(){

            @Override
            public int getSize() {
                return t.getSize();
            }

            @Override
            public int get(int index) {
                return t.get(t.getSize() - 1 - index);
            }

            @Override
            public void set(int index, int value) {
                t.set(t.getSize() - 1 - index, value);
            }
        };
    }

    public static MutableIntTuple clamp(IntTuple t, int min, int max, MutableIntTuple result) {
        result = IntTuples.validate(t, result);
        for (int i = 0; i < result.getSize(); ++i) {
            int v = t.get(i);
            int r = Math.min(max, Math.max(min, v));
            result.set(i, r);
        }
        return result;
    }

    public static MutableIntTuple clamp(IntTuple t, IntTuple min, IntTuple max, MutableIntTuple result) {
        Utils.checkForEqualSize(min, max);
        result = IntTuples.validate(t, result);
        for (int i = 0; i < result.getSize(); ++i) {
            int v = t.get(i);
            int minV = min.get(i);
            int maxV = max.get(i);
            int r = Math.min(maxV, Math.max(minV, v));
            result.set(i, r);
        }
        return result;
    }

    public static MutableIntTuple negate(IntTuple t0, MutableIntTuple result) {
        return IntTupleFunctions.apply(t0, a -> -a, result);
    }

    public static MutableIntTuple add(IntTuple t0, IntTuple t1, MutableIntTuple result) {
        return IntTupleFunctions.apply(t0, t1, (a, b) -> a + b, result);
    }

    public static MutableIntTuple subtract(IntTuple t0, IntTuple t1, MutableIntTuple result) {
        return IntTupleFunctions.apply(t0, t1, (a, b) -> a - b, result);
    }

    public static MutableIntTuple multiply(IntTuple t0, IntTuple t1, MutableIntTuple result) {
        return IntTupleFunctions.apply(t0, t1, (a, b) -> a * b, result);
    }

    public static MutableIntTuple divide(IntTuple t0, IntTuple t1, MutableIntTuple result) {
        return IntTupleFunctions.apply(t0, t1, (a, b) -> a / b, result);
    }

    public static MutableIntTuple add(IntTuple t0, int value, MutableIntTuple result) {
        return IntTupleFunctions.apply(t0, a -> a + value, result);
    }

    public static MutableIntTuple subtract(IntTuple t0, int value, MutableIntTuple result) {
        return IntTupleFunctions.apply(t0, a -> a - value, result);
    }

    public static MutableIntTuple multiply(IntTuple t0, int factor, MutableIntTuple result) {
        return IntTupleFunctions.apply(t0, a -> a * factor, result);
    }

    public static MutableIntTuple addScaled(IntTuple t0, int factor, IntTuple t1, MutableIntTuple result) {
        return IntTupleFunctions.apply(t0, t1, (a, b) -> a + factor * b, result);
    }

    public static int dot(IntTuple t0, IntTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        int result = 0;
        for (int i = 0; i < t0.getSize(); ++i) {
            result += t0.get(i) * t1.get(i);
        }
        return result;
    }

    public static int min(IntTuple t) {
        return IntTupleFunctions.reduce(t, Integer.MAX_VALUE, Math::min);
    }

    public static int max(IntTuple t) {
        return IntTupleFunctions.reduce(t, Integer.MIN_VALUE, Math::max);
    }

    public static MutableIntTuple min(IntTuple t0, IntTuple t1, MutableIntTuple result) {
        return IntTupleFunctions.apply(t0, t1, Math::min, result);
    }

    public static MutableIntTuple max(IntTuple t0, IntTuple t1, MutableIntTuple result) {
        return IntTupleFunctions.apply(t0, t1, Math::max, result);
    }

    public static int compareLexicographically(IntTuple t0, IntTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        for (int i = 0; i < t0.getSize(); ++i) {
            if (t0.get(i) < t1.get(i)) {
                return -1;
            }
            if (t0.get(i) <= t1.get(i)) continue;
            return 1;
        }
        return 0;
    }

    public static int compareColexicographically(IntTuple t0, IntTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        for (int i = t0.getSize() - 1; i >= 0; --i) {
            if (t0.get(i) < t1.get(i)) {
                return -1;
            }
            if (t0.get(i) <= t1.get(i)) continue;
            return 1;
        }
        return 0;
    }

    public static Comparator<IntTuple> comparator(Order order) {
        if (order == Order.LEXICOGRAPHICAL) {
            return (t0, t1) -> IntTuples.compareLexicographically(t0, t1);
        }
        if (order == Order.COLEXICOGRAPHICAL) {
            return (t0, t1) -> IntTuples.compareColexicographically(t0, t1);
        }
        return null;
    }

    public static boolean areElementsGreaterThan(IntTuple t0, IntTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        for (int i = 0; i < t0.getSize(); ++i) {
            if (t0.get(i) > t1.get(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsGreaterThanOrEqual(IntTuple t0, IntTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        for (int i = 0; i < t0.getSize(); ++i) {
            if (t0.get(i) >= t1.get(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsLessThan(IntTuple t0, IntTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        for (int i = 0; i < t0.getSize(); ++i) {
            if (t0.get(i) < t1.get(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsLessThanOrEqual(IntTuple t0, IntTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        for (int i = 0; i < t0.getSize(); ++i) {
            if (t0.get(i) <= t1.get(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsGreaterThan(IntTuple t, int value) {
        for (int i = 0; i < t.getSize(); ++i) {
            if (t.get(i) > value) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsGreaterThanOrEqual(IntTuple t, int value) {
        for (int i = 0; i < t.getSize(); ++i) {
            if (t.get(i) >= value) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsLessThan(IntTuple t, int value) {
        for (int i = 0; i < t.getSize(); ++i) {
            if (t.get(i) < value) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsLessThanOrEqual(IntTuple t, int value) {
        for (int i = 0; i < t.getSize(); ++i) {
            if (t.get(i) <= value) continue;
            return false;
        }
        return true;
    }

    static MutableIntTuple validate(IntTuple t, MutableIntTuple result) {
        if (result == null) {
            result = IntTuples.create(t.getSize());
        } else {
            Utils.checkForEqualSize(t, result);
        }
        return result;
    }

    static String toString(IntTuple tuple) {
        if (tuple == null) {
            return "null";
        }
        return IntTuples.toString(tuple, tuple.getSize(), tuple.getSize());
    }

    static String toString(IntTuple tuple, Locale locale, String format) {
        if (tuple == null) {
            return "null";
        }
        return IntTuples.toString(tuple, locale, format, tuple.getSize(), tuple.getSize());
    }

    public static String toString(IntTuple tuple, int maxNumLeadingElements, int maxNumTrailingElements) {
        return IntTuples.toString(tuple, null, null, maxNumLeadingElements, maxNumTrailingElements);
    }

    public static String toString(IntTuple tuple, Locale locale, String format, int maxNumLeadingElements, int maxNumTrailingElements) {
        if (tuple == null) {
            return "null";
        }
        maxNumLeadingElements = Math.max(0, maxNumLeadingElements);
        maxNumTrailingElements = Math.max(0, maxNumTrailingElements);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int n = tuple.getSize();
        if (n <= maxNumLeadingElements + maxNumTrailingElements) {
            IntTuples.appendRange(sb, tuple, locale, format, 0, n);
        } else {
            IntTuples.appendRange(sb, tuple, locale, format, 0, maxNumLeadingElements);
            if (maxNumLeadingElements > 0) {
                sb.append(", ");
            }
            sb.append("...");
            if (maxNumTrailingElements > 0) {
                sb.append(", ");
            }
            IntTuples.appendRange(sb, tuple, locale, format, n - maxNumTrailingElements, n);
        }
        sb.append(")");
        return sb.toString();
    }

    private static void appendRange(StringBuilder sb, IntTuple tuple, Locale locale, String format, int min, int max) {
        for (int i = min; i < max; ++i) {
            if (i > min) {
                sb.append(", ");
            }
            if (locale != null && format != null) {
                sb.append(String.format(locale, format, tuple.get(i)));
                continue;
            }
            sb.append(String.valueOf(tuple.get(i)));
        }
    }

    static int hashCode(IntTuple tuple) {
        if (tuple == null) {
            return 0;
        }
        int result = 0;
        for (int i = 0; i < tuple.getSize(); ++i) {
            int value = tuple.get(i);
            result += Integer.hashCode(value);
        }
        return result;
    }

    static boolean equals(IntTuple tuple, Object object) {
        if (tuple == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof IntTuple)) {
            return false;
        }
        IntTuple other = (IntTuple)object;
        if (other.getSize() != tuple.getSize()) {
            return false;
        }
        for (int i = 0; i < tuple.getSize(); ++i) {
            if (tuple.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    static boolean epsilonEquals(IntTuple t0, IntTuple t1, int epsilon) {
        int n1;
        if (t0 == t1) {
            return true;
        }
        int n0 = t0.getSize();
        if (n0 != (n1 = t1.getSize())) {
            return false;
        }
        for (int i = 0; i < n0; ++i) {
            int v1;
            int v0 = t0.get(i);
            if (Math.abs(v0 - (v1 = t1.get(i))) <= epsilon) continue;
            return false;
        }
        return true;
    }

    public static MutableDoubleTuple toDoubleTuple(IntTuple intTuple) {
        int d = intTuple.getSize();
        MutableDoubleTuple doubleTuple = DoubleTuples.create(d);
        for (int i = 0; i < d; ++i) {
            doubleTuple.set(i, intTuple.get(i));
        }
        return doubleTuple;
    }

    public static MutableIntTuple of(int x) {
        return new DefaultIntTuple(new int[]{x});
    }

    public static MutableIntTuple of(int x, int y) {
        return new IntTuple2(x, y);
    }

    public static MutableIntTuple of(int x, int y, int z) {
        return new DefaultIntTuple(x, y, z);
    }

    public static MutableIntTuple of(int x, int y, int z, int w) {
        return new DefaultIntTuple(x, y, z, w);
    }

    public static boolean incrementLexicographically(IntTuple t, IntTuple min, IntTuple max, MutableIntTuple result) {
        Utils.checkForEqualSize(t, min);
        Utils.checkForEqualSize(t, max);
        Utils.checkForEqualSize(t, result);
        if (result != t) {
            result.set(t);
        }
        return IntTuples.incrementLexicographically(result, min, max, result.getSize() - 1);
    }

    private static boolean incrementLexicographically(MutableIntTuple current, IntTuple min, IntTuple max, int index) {
        if (index == -1) {
            return false;
        }
        int oldValue = current.get(index);
        int newValue = oldValue + 1;
        current.set(index, newValue);
        if (newValue >= max.get(index)) {
            current.set(index, min.get(index));
            return IntTuples.incrementLexicographically(current, min, max, index - 1);
        }
        return true;
    }

    public static boolean incrementColexicographically(IntTuple t, IntTuple min, IntTuple max, MutableIntTuple result) {
        Utils.checkForEqualSize(t, min);
        Utils.checkForEqualSize(t, max);
        Utils.checkForEqualSize(t, result);
        if (result != t) {
            result.set(t);
        }
        return IntTuples.incrementColexicographically(result, min, max, 0);
    }

    static boolean incrementColexicographically(MutableIntTuple current, IntTuple min, IntTuple max, int index) {
        if (index == max.getSize()) {
            return false;
        }
        int oldValue = current.get(index);
        int newValue = oldValue + 1;
        current.set(index, newValue);
        if (newValue >= max.get(index)) {
            current.set(index, min.get(index));
            return IntTuples.incrementColexicographically(current, min, max, index + 1);
        }
        return true;
    }

    private IntTuples() {
    }

    static {
        for (int i = 0; i < 5; ++i) {
            IntTuples.ZEROS[i] = IntTuples.createZero(i);
        }
    }
}

