/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.i;

import de.javagl.nd.tuples.Utils;
import de.javagl.nd.tuples.i.AbstractMutableIntTuple;
import de.javagl.nd.tuples.i.IntTuples;
import de.javagl.nd.tuples.i.MutableIntTuple;

final class MutableSubIntTuple
extends AbstractMutableIntTuple {
    private final MutableIntTuple parent;
    private final int offset;
    private final int size;

    MutableSubIntTuple(MutableIntTuple parent, int fromIndex, int toIndex) {
        Utils.checkForValidSubTupleIndices(parent.getSize(), fromIndex, toIndex);
        this.parent = parent;
        this.offset = fromIndex;
        this.size = toIndex - fromIndex;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int get(int index) {
        Utils.checkForValidIndex(index, this.size);
        return this.parent.get(index + this.offset);
    }

    @Override
    public void set(int index, int value) {
        Utils.checkForValidIndex(index, this.size);
        this.parent.set(index + this.offset, value);
    }

    @Override
    public MutableIntTuple subTuple(int fromIndex, int toIndex) {
        return IntTuples.createSubTuple(this.parent, this.offset + fromIndex, this.offset + toIndex);
    }
}

