/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.i;

import de.javagl.nd.tuples.Utils;
import de.javagl.nd.tuples.i.AbstractIntTuple;
import de.javagl.nd.tuples.i.IntTuple;
import de.javagl.nd.tuples.i.IntTuples;

final class SubIntTuple
extends AbstractIntTuple {
    private final IntTuple parent;
    private final int offset;
    private final int size;

    SubIntTuple(IntTuple parent, int fromIndex, int toIndex) {
        Utils.checkForValidSubTupleIndices(parent.getSize(), fromIndex, toIndex);
        this.parent = parent;
        this.offset = fromIndex;
        this.size = toIndex - fromIndex;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int get(int index) {
        Utils.checkForValidIndex(index, this.size);
        return this.parent.get(index + this.offset);
    }

    @Override
    public IntTuple subTuple(int fromIndex, int toIndex) {
        return IntTuples.createSubTuple(this.parent, this.offset + fromIndex, this.offset + toIndex);
    }
}

