/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.j;

import de.javagl.nd.tuples.Utils;
import de.javagl.nd.tuples.j.AbstractMutableLongTuple;
import de.javagl.nd.tuples.j.MutableLongTuple;
import java.util.Arrays;
import java.util.stream.LongStream;

final class ArrayLongTuple
extends AbstractMutableLongTuple {
    private final long[] data;
    private final int offset;
    private final int size;

    ArrayLongTuple(long[] data, int offset, int size) {
        if (offset < 0) {
            throw new IllegalArgumentException("The offset is negative: " + offset);
        }
        if (size < 0) {
            throw new IllegalArgumentException("The size is negative: " + size);
        }
        if (offset + size > data.length) {
            throw new IllegalArgumentException("The offset is " + offset + " and size is " + size + ". " + "The array length must be at least " + (offset + size) + ", but only is " + data.length);
        }
        this.data = data;
        this.offset = offset;
        this.size = size;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public long get(int index) {
        Utils.checkForValidIndex(index, this.size);
        return this.data[index + this.offset];
    }

    @Override
    public void set(int index, long value) {
        Utils.checkForValidIndex(index, this.size);
        this.data[index + this.offset] = value;
    }

    @Override
    public MutableLongTuple subTuple(int fromIndex, int toIndex) {
        return new ArrayLongTuple(this.data, this.offset + fromIndex, toIndex - fromIndex);
    }

    @Override
    public LongStream stream() {
        return Arrays.stream(this.data);
    }
}

