/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.j;

import de.javagl.nd.tuples.Utils;
import de.javagl.nd.tuples.j.AbstractMutableLongTuple;
import de.javagl.nd.tuples.j.MutableLongTuple;
import java.nio.LongBuffer;
import java.util.Objects;

final class BufferLongTuple
extends AbstractMutableLongTuple {
    private final LongBuffer buffer;

    BufferLongTuple(LongBuffer buffer) {
        Objects.requireNonNull(buffer, "The buffer is null");
        this.buffer = buffer;
    }

    @Override
    public int getSize() {
        return this.buffer.capacity();
    }

    @Override
    public long get(int index) {
        return this.buffer.get(index);
    }

    @Override
    public void set(int index, long value) {
        this.buffer.put(index, value);
    }

    @Override
    public MutableLongTuple subTuple(int fromIndex, int toIndex) {
        Utils.checkForValidSubTupleIndices(this.getSize(), fromIndex, toIndex);
        int oldPosition = this.buffer.position();
        int oldLimit = this.buffer.limit();
        this.buffer.position(fromIndex);
        this.buffer.limit(oldPosition + (toIndex - fromIndex));
        BufferLongTuple result = new BufferLongTuple(this.buffer.slice());
        this.buffer.position(oldPosition);
        this.buffer.limit(oldLimit);
        return result;
    }
}

