/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.j;

import de.javagl.nd.tuples.j.AbstractLongTuple;
import de.javagl.nd.tuples.j.LongTuple;
import de.javagl.nd.tuples.j.LongTuples;

final class ConstantLongTuple
extends AbstractLongTuple
implements LongTuple {
    private final int size;
    private final long value;

    ConstantLongTuple(int size, long value) {
        if (size < 0) {
            throw new IllegalArgumentException("Size is negative: " + size);
        }
        this.size = size;
        this.value = value;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public long get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index " + index + ", size " + this.size);
        }
        return this.value;
    }

    @Override
    public LongTuple subTuple(int fromIndex, int toIndex) {
        return LongTuples.constant(toIndex - fromIndex, this.value);
    }
}

