/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.j;

import de.javagl.nd.tuples.j.AbstractMutableLongTuple;
import de.javagl.nd.tuples.j.LongTuple;
import java.util.Objects;

class DefaultLongTuple
extends AbstractMutableLongTuple {
    private final long[] data;

    DefaultLongTuple(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("The size is negative: " + size);
        }
        this.data = new long[size];
    }

    DefaultLongTuple(long ... data) {
        Objects.requireNonNull(data, "The data is null");
        this.data = data;
    }

    DefaultLongTuple(LongTuple other) {
        this.data = new long[other.getSize()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = other.get(i);
        }
    }

    @Override
    public int getSize() {
        return this.data.length;
    }

    @Override
    public long get(int index) {
        return this.data[index];
    }

    @Override
    public void set(int index, long value) {
        this.data[index] = value;
    }
}

