/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.j;

import de.javagl.nd.tuples.Tuple;
import de.javagl.nd.tuples.j.LongTuple;
import de.javagl.nd.tuples.j.LongTuples;
import de.javagl.nd.tuples.j.MutableLongTuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class LongTupleCollections {
    public static void create(int dimensions, int numElements, Collection<? super MutableLongTuple> target) {
        for (int i = 0; i < numElements; ++i) {
            target.add(LongTuples.create(dimensions));
        }
    }

    public static List<MutableLongTuple> create(int dimensions, int numElements) {
        ArrayList<MutableLongTuple> list = new ArrayList<MutableLongTuple>();
        LongTupleCollections.create(dimensions, numElements, list);
        return list;
    }

    public static List<MutableLongTuple> deepCopy(Collection<? extends LongTuple> tuples) {
        ArrayList<MutableLongTuple> result = new ArrayList<MutableLongTuple>(tuples.size());
        for (LongTuple longTuple : tuples) {
            if (longTuple == null) {
                result.add(null);
                continue;
            }
            result.add(LongTuples.copy(longTuple));
        }
        return result;
    }

    public static MutableLongTuple min(Collection<? extends LongTuple> tuples, MutableLongTuple result) {
        if (tuples.isEmpty()) {
            return null;
        }
        int size = LongTupleCollections.getSize(result, tuples);
        LongTuple identity = LongTuples.constant(size, Long.MAX_VALUE);
        MutableLongTuple localResult = tuples.parallelStream().collect(() -> LongTuples.copy(identity), (r, t) -> LongTuples.min(r, t, r), (r0, r1) -> LongTuples.min(r0, r1, r0));
        if (result == null) {
            return localResult;
        }
        result.set(localResult);
        return result;
    }

    public static MutableLongTuple max(Collection<? extends LongTuple> tuples, MutableLongTuple result) {
        if (tuples.isEmpty()) {
            return null;
        }
        int size = LongTupleCollections.getSize(result, tuples);
        LongTuple identity = LongTuples.constant(size, Long.MIN_VALUE);
        MutableLongTuple localResult = tuples.parallelStream().collect(() -> LongTuples.copy(identity), (r, t) -> LongTuples.max(r, t, r), (r0, r1) -> LongTuples.max(r0, r1, r0));
        if (result == null) {
            return localResult;
        }
        result.set(localResult);
        return result;
    }

    public static MutableLongTuple add(Collection<? extends LongTuple> tuples, MutableLongTuple result) {
        if (tuples.isEmpty()) {
            return null;
        }
        int size = LongTupleCollections.getSize(result, tuples);
        MutableLongTuple localResult = tuples.parallelStream().collect(() -> LongTuples.create(size), (r, t) -> LongTuples.add((LongTuple)r, t, r), (r0, r1) -> LongTuples.add((LongTuple)r0, r1, r0));
        if (result == null) {
            return localResult;
        }
        result.set(localResult);
        return result;
    }

    private static int getSize(Tuple t, Iterable<? extends Tuple> tuples) {
        Tuple first;
        if (t != null) {
            return t.getSize();
        }
        Iterator<? extends Tuple> iterator = tuples.iterator();
        if (iterator.hasNext() && (first = iterator.next()) != null) {
            return first.getSize();
        }
        return -1;
    }

    private LongTupleCollections() {
    }
}

