/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.j;

import de.javagl.nd.tuples.Utils;
import de.javagl.nd.tuples.j.LongTuple;
import de.javagl.nd.tuples.j.LongTuples;
import de.javagl.nd.tuples.j.MutableLongTuple;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;

public class LongTupleFunctions {
    public static MutableLongTuple apply(LongTuple t0, LongTuple t1, LongBinaryOperator op, MutableLongTuple result) {
        Utils.checkForEqualSize(t0, t1);
        result = LongTuples.validate(t0, result);
        int n = t0.getSize();
        for (int i = 0; i < n; ++i) {
            long operand0 = t0.get(i);
            long operand1 = t1.get(i);
            long r = op.applyAsLong(operand0, operand1);
            result.set(i, r);
        }
        return result;
    }

    public static MutableLongTuple apply(LongTuple t0, LongUnaryOperator op, MutableLongTuple result) {
        result = LongTuples.validate(t0, result);
        int n = t0.getSize();
        for (int i = 0; i < n; ++i) {
            long operand0 = t0.get(i);
            long r = op.applyAsLong(operand0);
            result.set(i, r);
        }
        return result;
    }

    public static long reduce(LongTuple t0, long identity, LongBinaryOperator op) {
        long result = identity;
        int n = t0.getSize();
        for (int i = 0; i < n; ++i) {
            long operand0 = t0.get(i);
            result = op.applyAsLong(result, operand0);
        }
        return result;
    }

    public static MutableLongTuple inclusiveScan(LongTuple t0, LongBinaryOperator op, MutableLongTuple result) {
        result = LongTuples.validate(t0, result);
        int n = t0.getSize();
        if (n > 0) {
            result.set(0, t0.get(0));
            for (int i = 1; i < n; ++i) {
                long operand0 = result.get(i - 1);
                long operand1 = t0.get(i);
                long r = op.applyAsLong(operand0, operand1);
                result.set(i, r);
            }
        }
        return result;
    }

    public static MutableLongTuple exclusiveScan(LongTuple t0, long identity, LongBinaryOperator op, MutableLongTuple result) {
        result = LongTuples.validate(t0, result);
        int n = t0.getSize();
        if (n > 0) {
            long previousElement = t0.get(0);
            result.set(0, identity);
            for (int i = 1; i < n; ++i) {
                long operand0 = result.get(i - 1);
                long operand1 = previousElement;
                long r = op.applyAsLong(operand0, operand1);
                previousElement = t0.get(i);
                result.set(i, r);
            }
        }
        return result;
    }

    private LongTupleFunctions() {
    }
}

