/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.j;

import de.javagl.nd.tuples.j.LongTuple;
import java.util.Comparator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.LongConsumer;

class LongTupleSpliterator
implements Spliterator.OfLong {
    private final LongTuple tuple;
    private int index;
    private final int end;
    private final int characteristics;

    public LongTupleSpliterator(LongTuple tuple, int index, int end) {
        this.tuple = tuple;
        this.index = index;
        this.end = end;
        this.characteristics = 17488;
    }

    @Override
    public Spliterator.OfLong trySplit() {
        int center = this.index + this.end >> 1;
        if (this.index >= center) {
            return null;
        }
        LongTupleSpliterator result = new LongTupleSpliterator(this.tuple, this.index, center);
        this.index = center;
        return result;
    }

    @Override
    public void forEachRemaining(LongConsumer action) {
        Objects.requireNonNull(action, "The action is null");
        if (this.index >= 0 && this.end <= this.tuple.getSize()) {
            while (this.index < this.end) {
                action.accept(this.tuple.get(this.index++));
            }
        }
    }

    @Override
    public boolean tryAdvance(LongConsumer action) {
        Objects.requireNonNull(action, "The action is null");
        if (this.index >= 0 && this.index < this.end) {
            action.accept(this.tuple.get(this.index++));
            return true;
        }
        return false;
    }

    @Override
    public long estimateSize() {
        return this.end - this.index;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    @Override
    public Comparator<? super Long> getComparator() {
        return null;
    }
}

