/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.j;

import de.javagl.nd.tuples.Order;
import de.javagl.nd.tuples.Utils;
import de.javagl.nd.tuples.d.DoubleTuples;
import de.javagl.nd.tuples.d.MutableDoubleTuple;
import de.javagl.nd.tuples.j.AbstractLongTuple;
import de.javagl.nd.tuples.j.AbstractMutableLongTuple;
import de.javagl.nd.tuples.j.ArrayLongTuple;
import de.javagl.nd.tuples.j.BufferLongTuple;
import de.javagl.nd.tuples.j.ConstantLongTuple;
import de.javagl.nd.tuples.j.DefaultLongTuple;
import de.javagl.nd.tuples.j.LongTuple;
import de.javagl.nd.tuples.j.LongTupleFunctions;
import de.javagl.nd.tuples.j.MutableLongTuple;
import de.javagl.nd.tuples.j.MutableSubLongTuple;
import de.javagl.nd.tuples.j.SubLongTuple;
import java.nio.LongBuffer;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class LongTuples {
    private static final int ZERO_POOL_SIZE = 5;
    private static final LongTuple[] ZEROS = new LongTuple[5];

    private static LongTuple createZero(int size) {
        return LongTuples.constant(size, 0L);
    }

    public static LongTuple zero(int size) {
        if (size >= 0 && size < 5) {
            return ZEROS[size];
        }
        return LongTuples.createZero(size);
    }

    public static LongTuple constant(int size, long value) {
        return new ConstantLongTuple(size, value);
    }

    public static MutableLongTuple create(int size) {
        return new DefaultLongTuple(size);
    }

    public static MutableLongTuple copy(LongTuple other) {
        return new DefaultLongTuple(other);
    }

    public static MutableLongTuple of(long ... values) {
        return new DefaultLongTuple((long[])values.clone());
    }

    public static MutableLongTuple wrap(long ... values) {
        return new DefaultLongTuple(values);
    }

    public static MutableLongTuple wrap(LongBuffer buffer) {
        return new BufferLongTuple(buffer);
    }

    public static MutableLongTuple wrap(long[] data, int offset, int size) {
        return new ArrayLongTuple(data, offset, size);
    }

    static LongTuple createSubTuple(LongTuple parent, int fromIndex, int toIndex) {
        return new SubLongTuple(parent, fromIndex, toIndex);
    }

    static MutableLongTuple createSubTuple(MutableLongTuple parent, int fromIndex, int toIndex) {
        return new MutableSubLongTuple(parent, fromIndex, toIndex);
    }

    public static long[] toArray(LongTuple t) {
        int d = t.getSize();
        long[] result = new long[d];
        for (int i = 0; i < d; ++i) {
            result[i] = t.get(i);
        }
        return result;
    }

    public static List<Long> asList(final LongTuple t) {
        if (t == null) {
            throw new NullPointerException("The tuple may not be null");
        }
        return new AbstractList<Long>(){

            @Override
            public Long get(int index) {
                return t.get(index);
            }

            @Override
            public int size() {
                return t.getSize();
            }
        };
    }

    public static List<Long> asList(final MutableLongTuple t) {
        if (t == null) {
            throw new NullPointerException("The tuple may not be null");
        }
        return new AbstractList<Long>(){

            @Override
            public Long get(int index) {
                return t.get(index);
            }

            @Override
            public int size() {
                return t.getSize();
            }

            @Override
            public Long set(int index, Long element) {
                long oldValue = t.get(index);
                t.set(index, element);
                return oldValue;
            }
        };
    }

    public static void set(MutableLongTuple t, long v) {
        for (int i = 0; i < t.getSize(); ++i) {
            t.set(i, v);
        }
    }

    public static MutableLongTuple reverse(LongTuple t, MutableLongTuple result) {
        if (t == (result = LongTuples.validate(t, result))) {
            int n = t.getSize();
            int nh = n / 2;
            for (int i = 0; i < nh; ++i) {
                long temp = result.get(i);
                result.set(i, result.get(n - 1 - i));
                result.set(n - 1 - i, temp);
            }
        } else {
            int n = t.getSize();
            for (int i = 0; i < n; ++i) {
                result.set(i, t.get(n - 1 - i));
            }
        }
        return result;
    }

    public static LongTuple reversed(final LongTuple t) {
        Objects.requireNonNull(t, "The input tuple is null");
        return new AbstractLongTuple(){

            @Override
            public int getSize() {
                return t.getSize();
            }

            @Override
            public long get(int index) {
                return t.get(t.getSize() - 1 - index);
            }
        };
    }

    public static MutableLongTuple reversed(final MutableLongTuple t) {
        Objects.requireNonNull(t, "The input tuple is null");
        return new AbstractMutableLongTuple(){

            @Override
            public int getSize() {
                return t.getSize();
            }

            @Override
            public long get(int index) {
                return t.get(t.getSize() - 1 - index);
            }

            @Override
            public void set(int index, long value) {
                t.set(t.getSize() - 1 - index, value);
            }
        };
    }

    public static MutableLongTuple clamp(LongTuple t, long min, long max, MutableLongTuple result) {
        result = LongTuples.validate(t, result);
        for (int i = 0; i < result.getSize(); ++i) {
            long v = t.get(i);
            long r = Math.min(max, Math.max(min, v));
            result.set(i, r);
        }
        return result;
    }

    public static MutableLongTuple clamp(LongTuple t, LongTuple min, LongTuple max, MutableLongTuple result) {
        Utils.checkForEqualSize(min, max);
        result = LongTuples.validate(t, result);
        for (int i = 0; i < result.getSize(); ++i) {
            long v = t.get(i);
            long minV = min.get(i);
            long maxV = max.get(i);
            long r = Math.min(maxV, Math.max(minV, v));
            result.set(i, r);
        }
        return result;
    }

    public static MutableLongTuple negate(LongTuple t0, MutableLongTuple result) {
        return LongTupleFunctions.apply(t0, a -> -a, result);
    }

    public static MutableLongTuple add(LongTuple t0, LongTuple t1, MutableLongTuple result) {
        return LongTupleFunctions.apply(t0, t1, (a, b) -> a + b, result);
    }

    public static MutableLongTuple subtract(LongTuple t0, LongTuple t1, MutableLongTuple result) {
        return LongTupleFunctions.apply(t0, t1, (a, b) -> a - b, result);
    }

    public static MutableLongTuple multiply(LongTuple t0, LongTuple t1, MutableLongTuple result) {
        return LongTupleFunctions.apply(t0, t1, (a, b) -> a * b, result);
    }

    public static MutableLongTuple divide(LongTuple t0, LongTuple t1, MutableLongTuple result) {
        return LongTupleFunctions.apply(t0, t1, (a, b) -> a / b, result);
    }

    public static MutableLongTuple add(LongTuple t0, long value, MutableLongTuple result) {
        return LongTupleFunctions.apply(t0, a -> a + value, result);
    }

    public static MutableLongTuple subtract(LongTuple t0, long value, MutableLongTuple result) {
        return LongTupleFunctions.apply(t0, a -> a - value, result);
    }

    public static MutableLongTuple multiply(LongTuple t0, long factor, MutableLongTuple result) {
        return LongTupleFunctions.apply(t0, a -> a * factor, result);
    }

    public static MutableLongTuple addScaled(LongTuple t0, long factor, LongTuple t1, MutableLongTuple result) {
        return LongTupleFunctions.apply(t0, t1, (a, b) -> a + factor * b, result);
    }

    public static long dot(LongTuple t0, LongTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        long result = 0L;
        for (int i = 0; i < t0.getSize(); ++i) {
            result += t0.get(i) * t1.get(i);
        }
        return result;
    }

    public static long min(LongTuple t) {
        return LongTupleFunctions.reduce(t, Long.MAX_VALUE, Math::min);
    }

    public static long max(LongTuple t) {
        return LongTupleFunctions.reduce(t, Long.MIN_VALUE, Math::max);
    }

    public static MutableLongTuple min(LongTuple t0, LongTuple t1, MutableLongTuple result) {
        return LongTupleFunctions.apply(t0, t1, Math::min, result);
    }

    public static MutableLongTuple max(LongTuple t0, LongTuple t1, MutableLongTuple result) {
        return LongTupleFunctions.apply(t0, t1, Math::max, result);
    }

    public static int compareLexicographically(LongTuple t0, LongTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        for (int i = 0; i < t0.getSize(); ++i) {
            if (t0.get(i) < t1.get(i)) {
                return -1;
            }
            if (t0.get(i) <= t1.get(i)) continue;
            return 1;
        }
        return 0;
    }

    public static int compareColexicographically(LongTuple t0, LongTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        for (int i = t0.getSize() - 1; i >= 0; --i) {
            if (t0.get(i) < t1.get(i)) {
                return -1;
            }
            if (t0.get(i) <= t1.get(i)) continue;
            return 1;
        }
        return 0;
    }

    public static Comparator<LongTuple> comparator(Order order) {
        if (order == Order.LEXICOGRAPHICAL) {
            return (t0, t1) -> LongTuples.compareLexicographically(t0, t1);
        }
        if (order == Order.COLEXICOGRAPHICAL) {
            return (t0, t1) -> LongTuples.compareColexicographically(t0, t1);
        }
        return null;
    }

    public static boolean areElementsGreaterThan(LongTuple t0, LongTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        for (int i = 0; i < t0.getSize(); ++i) {
            if (t0.get(i) > t1.get(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsGreaterThanOrEqual(LongTuple t0, LongTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        for (int i = 0; i < t0.getSize(); ++i) {
            if (t0.get(i) >= t1.get(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsLessThan(LongTuple t0, LongTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        for (int i = 0; i < t0.getSize(); ++i) {
            if (t0.get(i) < t1.get(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsLessThanOrEqual(LongTuple t0, LongTuple t1) {
        Utils.checkForEqualSize(t0, t1);
        for (int i = 0; i < t0.getSize(); ++i) {
            if (t0.get(i) <= t1.get(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsGreaterThan(LongTuple t, long value) {
        for (int i = 0; i < t.getSize(); ++i) {
            if (t.get(i) > value) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsGreaterThanOrEqual(LongTuple t, long value) {
        for (int i = 0; i < t.getSize(); ++i) {
            if (t.get(i) >= value) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsLessThan(LongTuple t, long value) {
        for (int i = 0; i < t.getSize(); ++i) {
            if (t.get(i) < value) continue;
            return false;
        }
        return true;
    }

    public static boolean areElementsLessThanOrEqual(LongTuple t, long value) {
        for (int i = 0; i < t.getSize(); ++i) {
            if (t.get(i) <= value) continue;
            return false;
        }
        return true;
    }

    static MutableLongTuple validate(LongTuple t, MutableLongTuple result) {
        if (result == null) {
            result = LongTuples.create(t.getSize());
        } else {
            Utils.checkForEqualSize(t, result);
        }
        return result;
    }

    static String toString(LongTuple tuple) {
        if (tuple == null) {
            return "null";
        }
        return LongTuples.toString(tuple, tuple.getSize(), tuple.getSize());
    }

    static String toString(LongTuple tuple, Locale locale, String format) {
        if (tuple == null) {
            return "null";
        }
        return LongTuples.toString(tuple, locale, format, tuple.getSize(), tuple.getSize());
    }

    public static String toString(LongTuple tuple, int maxNumLeadingElements, int maxNumTrailingElements) {
        return LongTuples.toString(tuple, null, null, maxNumLeadingElements, maxNumTrailingElements);
    }

    public static String toString(LongTuple tuple, Locale locale, String format, int maxNumLeadingElements, int maxNumTrailingElements) {
        if (tuple == null) {
            return "null";
        }
        maxNumLeadingElements = Math.max(0, maxNumLeadingElements);
        maxNumTrailingElements = Math.max(0, maxNumTrailingElements);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int n = tuple.getSize();
        if (n <= maxNumLeadingElements + maxNumTrailingElements) {
            LongTuples.appendRange(sb, tuple, locale, format, 0, n);
        } else {
            LongTuples.appendRange(sb, tuple, locale, format, 0, maxNumLeadingElements);
            if (maxNumLeadingElements > 0) {
                sb.append(", ");
            }
            sb.append("...");
            if (maxNumTrailingElements > 0) {
                sb.append(", ");
            }
            LongTuples.appendRange(sb, tuple, locale, format, n - maxNumTrailingElements, n);
        }
        sb.append(")");
        return sb.toString();
    }

    private static void appendRange(StringBuilder sb, LongTuple tuple, Locale locale, String format, int min, int max) {
        for (int i = min; i < max; ++i) {
            if (i > min) {
                sb.append(", ");
            }
            if (locale != null && format != null) {
                sb.append(String.format(locale, format, tuple.get(i)));
                continue;
            }
            sb.append(String.valueOf(tuple.get(i)));
        }
    }

    static int hashCode(LongTuple tuple) {
        if (tuple == null) {
            return 0;
        }
        int result = 0;
        for (int i = 0; i < tuple.getSize(); ++i) {
            long value = tuple.get(i);
            result += Long.hashCode(value);
        }
        return result;
    }

    static boolean equals(LongTuple tuple, Object object) {
        if (tuple == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof LongTuple)) {
            return false;
        }
        LongTuple other = (LongTuple)object;
        if (other.getSize() != tuple.getSize()) {
            return false;
        }
        for (int i = 0; i < tuple.getSize(); ++i) {
            if (tuple.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    static boolean epsilonEquals(LongTuple t0, LongTuple t1, long epsilon) {
        int n1;
        if (t0 == t1) {
            return true;
        }
        int n0 = t0.getSize();
        if (n0 != (n1 = t1.getSize())) {
            return false;
        }
        for (int i = 0; i < n0; ++i) {
            long v1;
            long v0 = t0.get(i);
            if (Math.abs(v0 - (v1 = t1.get(i))) <= epsilon) continue;
            return false;
        }
        return true;
    }

    public static MutableDoubleTuple toDoubleTuple(LongTuple longTuple) {
        int d = longTuple.getSize();
        MutableDoubleTuple doubleTuple = DoubleTuples.create(d);
        for (int i = 0; i < d; ++i) {
            doubleTuple.set(i, longTuple.get(i));
        }
        return doubleTuple;
    }

    public static MutableLongTuple of(long x) {
        return new DefaultLongTuple(x);
    }

    public static MutableLongTuple of(int x, int y) {
        return new DefaultLongTuple(x, y);
    }

    public static MutableLongTuple of(long x, long y, long z) {
        return new DefaultLongTuple(x, y, z);
    }

    public static MutableLongTuple of(long x, long y, long z, long w) {
        return new DefaultLongTuple(x, y, z, w);
    }

    public static boolean incrementLexicographically(LongTuple t, LongTuple min, LongTuple max, MutableLongTuple result) {
        Utils.checkForEqualSize(t, min);
        Utils.checkForEqualSize(t, max);
        Utils.checkForEqualSize(t, result);
        if (result != t) {
            result.set(t);
        }
        return LongTuples.incrementLexicographically(result, min, max, result.getSize() - 1);
    }

    private static boolean incrementLexicographically(MutableLongTuple current, LongTuple min, LongTuple max, int index) {
        if (index == -1) {
            return false;
        }
        long oldValue = current.get(index);
        long newValue = oldValue + 1L;
        current.set(index, newValue);
        if (newValue >= max.get(index)) {
            current.set(index, min.get(index));
            return LongTuples.incrementLexicographically(current, min, max, index - 1);
        }
        return true;
    }

    public static boolean incrementColexicographically(LongTuple t, LongTuple min, LongTuple max, MutableLongTuple result) {
        Utils.checkForEqualSize(t, min);
        Utils.checkForEqualSize(t, max);
        Utils.checkForEqualSize(t, result);
        if (result != t) {
            result.set(t);
        }
        return LongTuples.incrementColexicographically(result, min, max, 0);
    }

    static boolean incrementColexicographically(MutableLongTuple current, LongTuple min, LongTuple max, int index) {
        if (index == max.getSize()) {
            return false;
        }
        long oldValue = current.get(index);
        long newValue = oldValue + 1L;
        current.set(index, newValue);
        if (newValue >= max.get(index)) {
            current.set(index, min.get(index));
            return LongTuples.incrementColexicographically(current, min, max, index + 1);
        }
        return true;
    }

    private LongTuples() {
    }

    static {
        for (int i = 0; i < 5; ++i) {
            LongTuples.ZEROS[i] = LongTuples.createZero(i);
        }
    }
}

