/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.j;

import de.javagl.nd.tuples.Utils;
import de.javagl.nd.tuples.j.AbstractMutableLongTuple;
import de.javagl.nd.tuples.j.LongTuples;
import de.javagl.nd.tuples.j.MutableLongTuple;

final class MutableSubLongTuple
extends AbstractMutableLongTuple {
    private final MutableLongTuple parent;
    private final int offset;
    private final int size;

    MutableSubLongTuple(MutableLongTuple parent, int fromIndex, int toIndex) {
        Utils.checkForValidSubTupleIndices(parent.getSize(), fromIndex, toIndex);
        this.parent = parent;
        this.offset = fromIndex;
        this.size = toIndex - fromIndex;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public long get(int index) {
        Utils.checkForValidIndex(index, this.size);
        return this.parent.get(index + this.offset);
    }

    @Override
    public void set(int index, long value) {
        Utils.checkForValidIndex(index, this.size);
        this.parent.set(index + this.offset, value);
    }

    @Override
    public MutableLongTuple subTuple(int fromIndex, int toIndex) {
        return LongTuples.createSubTuple(this.parent, this.offset + fromIndex, this.offset + toIndex);
    }
}

