/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.nd.tuples.j;

import de.javagl.nd.tuples.Utils;
import de.javagl.nd.tuples.j.AbstractLongTuple;
import de.javagl.nd.tuples.j.LongTuple;
import de.javagl.nd.tuples.j.LongTuples;

final class SubLongTuple
extends AbstractLongTuple {
    private final LongTuple parent;
    private final int offset;
    private final int size;

    SubLongTuple(LongTuple parent, int fromIndex, int toIndex) {
        Utils.checkForValidSubTupleIndices(parent.getSize(), fromIndex, toIndex);
        this.parent = parent;
        this.offset = fromIndex;
        this.size = toIndex - fromIndex;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public long get(int index) {
        Utils.checkForValidIndex(index, this.size);
        return this.parent.get(index + this.offset);
    }

    @Override
    public LongTuple subTuple(int fromIndex, int toIndex) {
        return LongTuples.createSubTuple(this.parent, this.offset + fromIndex, this.offset + toIndex);
    }
}

