/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.sampling.list;

import de.javagl.sampling.list.ListSampler;
import de.javagl.sampling.list.ListSampling;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ListSamplers {
    public static <T> List<List<T>> createList(ListSampler listSampler, List<? extends T> input, int numSamples) {
        return listSampler.createSamples(input).limit(numSamples).collect(Collectors.toList());
    }

    public static ListSampler createFull() {
        return new ListSampler(){

            @Override
            public <T> Stream<List<T>> createSamples(List<? extends T> input) {
                return Stream.generate(() -> Collections.unmodifiableList(input));
            }
        };
    }

    public static ListSampler createWithRelativeSize(final double relativeSampleSize, final Random random) {
        if (relativeSampleSize <= 0.0 || relativeSampleSize > 1.0) {
            throw new IllegalArgumentException("The relative sample size must be in (0.0, 1.0], but is " + relativeSampleSize);
        }
        return new ListSampler(){

            @Override
            public <T> Stream<List<T>> createSamples(List<? extends T> input) {
                if (input.isEmpty()) {
                    return Stream.generate(Collections::emptyList);
                }
                int sampleSize = (int)Math.ceil((double)input.size() * relativeSampleSize);
                return ListSampling.createSamples(input, sampleSize, random);
            }
        };
    }

    public static ListSampler createWithAbsoluteSize(final int absoluteSampleSize, final Random random) {
        if (absoluteSampleSize <= 0) {
            throw new IllegalArgumentException("The sample size must be positive, but is " + absoluteSampleSize);
        }
        return new ListSampler(){

            @Override
            public <T> Stream<List<T>> createSamples(List<? extends T> input) {
                if (input.size() <= absoluteSampleSize) {
                    return Stream.generate(() -> Collections.unmodifiableList(input));
                }
                return ListSampling.createSamples(input, absoluteSampleSize, random);
            }
        };
    }

    private ListSamplers() {
    }
}

