/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.sampling.list;

import de.javagl.sampling.list.RandomUtils;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;

public class ListSampling {
    public static <T> Stream<List<T>> createSamples(List<? extends T> list, int sampleSize, Random random) {
        ListSampling.validateSampleSize(sampleSize, list.size());
        Stream<List<T>> stream = Stream.generate(() -> {
            List next = ListSampling.createSample(list, sampleSize, random);
            return Collections.unmodifiableList(next);
        });
        return stream;
    }

    public static <T> List<T> createSample(List<? extends T> list, int sampleSize, Random random) {
        ListSampling.validateSampleSize(sampleSize, list.size());
        int[] indices = RandomUtils.randomSample(sampleSize, 0, list.size(), random);
        return ListSampling.createView(list, indices);
    }

    private static <T> List<T> createView(final List<? extends T> input, final int[] indices) {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                int inputIndex = indices[index];
                return input.get(inputIndex);
            }

            @Override
            public int size() {
                return indices.length;
            }
        };
    }

    private static void validateSampleSize(int sampleSize, int listSize) {
        if (sampleSize <= 0) {
            throw new IllegalArgumentException("The sample size must be positive, but is " + sampleSize);
        }
        if (sampleSize > listSize) {
            throw new IllegalArgumentException("Can not create a sample of size " + sampleSize + " from list with size " + listSize);
        }
    }

    private ListSampling() {
    }
}

